/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.generic;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import org.datatransferproject.datatransfer.generic.BlobIdToName;
import org.datatransferproject.datatransfer.generic.CachedDownloadableItem;
import org.datatransferproject.datatransfer.generic.FileExportData;
import org.datatransferproject.datatransfer.generic.FolderExportData;
import org.datatransferproject.datatransfer.generic.GenericPayload;
import org.datatransferproject.datatransfer.generic.ImportableData;
import org.datatransferproject.datatransfer.generic.ImportableFileData;
import org.datatransferproject.spi.cloud.storage.TemporaryPerJobDataStore;
import org.datatransferproject.transfer.JobMetadata;
import org.datatransferproject.types.common.models.DataModel;
import org.datatransferproject.types.common.models.blob.BlobbyStorageContainerResource;
import org.datatransferproject.types.common.models.blob.DigitalDocumentWrapper;

public class BlobbySerializer {
    static final String SCHEMA_SOURCE = "https://github.com/dtinit/data-transfer-project/blob/master/extensions/data-transfer/portability-data-transfer-generic/src/main/java/org/datatransferproject/datatransfer/generic/BlobbySerializer.java";
    private static final String BLOB_ID_TO_NAME_KEY = "blobIdToNameKey";
    private final TemporaryPerJobDataStore jobStore;
    private BlobIdToName blobIdToName;

    public BlobbySerializer(TemporaryPerJobDataStore jobStore) {
        this.jobStore = jobStore;
    }

    private void addToJobStore(String id, String name) throws IOException {
        this.initialiseBlobIdToNameIfNot(JobMetadata.getJobId());
        this.blobIdToName.add(id, name);
    }

    private void saveStateToStore() throws IOException {
        this.initialiseBlobIdToNameIfNot(JobMetadata.getJobId());
        this.jobStore.create(JobMetadata.getJobId(), BLOB_ID_TO_NAME_KEY, (DataModel)this.blobIdToName);
    }

    private String getFromStore(String id) throws IOException {
        this.initialiseBlobIdToNameIfNot(JobMetadata.getJobId());
        return this.blobIdToName.get(id);
    }

    private void initialiseBlobIdToNameIfNot(UUID jobId) throws IOException {
        if (this.blobIdToName == null) {
            this.blobIdToName = (BlobIdToName)this.jobStore.findData(jobId, BLOB_ID_TO_NAME_KEY, BlobIdToName.class);
            if (this.blobIdToName == null) {
                this.blobIdToName = new BlobIdToName();
            }
        }
    }

    public Iterable<ImportableData<ExportData>> serialize(BlobbyStorageContainerResource root) throws IOException {
        ArrayList<ImportableData<ExportData>> results = new ArrayList<ImportableData<ExportData>>();
        Object currentFolderPath = this.getFromStore(root.getId());
        if (currentFolderPath == null) {
            currentFolderPath = "/" + root.getName();
        }
        results.add(new ImportableData<FolderExportData>(new GenericPayload<FolderExportData>(new FolderExportData((String)currentFolderPath), SCHEMA_SOURCE), root.getId(), (String)currentFolderPath));
        for (BlobbyStorageContainerResource childFolder : root.getFolders()) {
            String path = String.format("%s/%s", currentFolderPath, childFolder.getName());
            results.add(new ImportableData<FolderExportData>(new GenericPayload<FolderExportData>(new FolderExportData(path), SCHEMA_SOURCE), childFolder.getId(), path));
            this.addToJobStore(childFolder.getId(), path);
        }
        for (DigitalDocumentWrapper file : root.getFiles()) {
            results.add(new ImportableFileData<FileExportData>(new CachedDownloadableItem(file.getCachedContentId(), file.getDtpDigitalDocument().getName()), file.getDtpDigitalDocument().getEncodingFormat(), new GenericPayload<FileExportData>(FileExportData.fromDtpDigitalDocument((String)currentFolderPath, file.getDtpDigitalDocument()), SCHEMA_SOURCE), file.getCachedContentId(), file.getDtpDigitalDocument().getName()));
        }
        this.saveStateToStore();
        return results;
    }

    @JsonSubTypes(value={@JsonSubTypes.Type(value=FolderExportData.class), @JsonSubTypes.Type(value=FileExportData.class)})
    public static interface ExportData {
    }
}

