/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.generic;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import java.util.stream.Collectors;
import org.datatransferproject.datatransfer.generic.GenericPayload;
import org.datatransferproject.datatransfer.generic.ImportableData;
import org.datatransferproject.datatransfer.generic.SocialActivity;
import org.datatransferproject.datatransfer.generic.SocialActivityMetadata;
import org.datatransferproject.types.common.models.social.SocialActivityContainerResource;
import org.datatransferproject.types.common.models.social.SocialActivityModel;

public class SocialPostsSerializer {
    static final String SCHEMA_SOURCE = "https://github.com/dtinit/data-transfer-project/blob/master/extensions/data-transfer/portability-data-transfer-generic/src/main/java/org/datatransferproject/datatransfer/generic/SocialPostsSerializer.java";

    public static Iterable<ImportableData<ExportData>> serialize(SocialActivityContainerResource container) {
        return container.getActivities().stream().map(activity -> new ImportableData<SocialActivity>(new GenericPayload<SocialActivity>(new SocialActivity(new SocialActivityMetadata(container.getActor()), (SocialActivityModel)activity), SCHEMA_SOURCE), activity.getIdempotentId(), activity.getName())).collect(Collectors.toList());
    }

    @JsonSubTypes(value={@JsonSubTypes.Type(value=SocialActivity.class)})
    public static interface ExportData {
    }
}

