/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.generic;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.datatransferproject.api.launcher.ExtensionContext;
import org.datatransferproject.datatransfer.generic.BlobbySerializer;
import org.datatransferproject.datatransfer.generic.CalendarSerializer;
import org.datatransferproject.datatransfer.generic.GenericFileImporter;
import org.datatransferproject.datatransfer.generic.GenericImporter;
import org.datatransferproject.datatransfer.generic.GenericTransferServiceConfig;
import org.datatransferproject.datatransfer.generic.MediaSerializer;
import org.datatransferproject.datatransfer.generic.SocialPostsSerializer;
import org.datatransferproject.spi.cloud.storage.AppCredentialStore;
import org.datatransferproject.spi.cloud.storage.JobStore;
import org.datatransferproject.spi.cloud.storage.TemporaryPerJobDataStore;
import org.datatransferproject.spi.transfer.extension.TransferExtension;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.types.common.models.DataVertical;
import org.datatransferproject.types.transfer.auth.AppCredentials;
import org.datatransferproject.types.transfer.serviceconfig.TransferServiceConfig;

public class GenericTransferExtension
implements TransferExtension {
    Map<DataVertical, Importer<?, ?>> importerMap = new HashMap();

    public boolean supportsService(String service) {
        try {
            TransferServiceConfig config = TransferServiceConfig.getForService((String)service);
            if (config.getServiceConfig().isEmpty()) {
                return false;
            }
            this.parseConfig((JsonNode)config.getServiceConfig().get());
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public void initialize(ExtensionContext context) {
        AppCredentials appCredentials;
        GenericTransferServiceConfig serviceConfig;
        JobStore jobStore = (JobStore)context.getService(JobStore.class);
        TransferServiceConfig configuration = (TransferServiceConfig)context.getService(TransferServiceConfig.class);
        if (configuration.getServiceConfig().isEmpty()) {
            throw new RuntimeException("Empty service configuration");
        }
        try {
            serviceConfig = this.parseConfig((JsonNode)configuration.getServiceConfig().get());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Invalid service configuration", e);
        }
        AppCredentialStore appCredentialStore = (AppCredentialStore)context.getService(AppCredentialStore.class);
        String serviceNameUpper = serviceConfig.getServiceId().toUpperCase();
        try {
            appCredentials = appCredentialStore.getAppCredentials(String.format("%s_KEY", serviceNameUpper), String.format("%s_SECRET", serviceNameUpper));
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to get application credentials for %s (%s)", serviceNameUpper, serviceConfig.getServiceId()), e);
        }
        if (serviceConfig.supportsVertical(DataVertical.BLOBS)) {
            this.importerMap.put(DataVertical.BLOBS, new GenericFileImporter(BlobbySerializer::serialize, appCredentials, this.urlAppend(serviceConfig.getEndpoint(), "blobs"), (TemporaryPerJobDataStore)jobStore, context.getMonitor()));
        }
        if (serviceConfig.supportsVertical(DataVertical.MEDIA) || serviceConfig.supportsVertical(DataVertical.PHOTOS) || serviceConfig.supportsVertical(DataVertical.VIDEOS)) {
            this.importerMap.put(DataVertical.MEDIA, new GenericFileImporter(MediaSerializer::serialize, appCredentials, this.urlAppend(serviceConfig.getEndpoint(), "media"), (TemporaryPerJobDataStore)jobStore, context.getMonitor()));
        }
        if (serviceConfig.supportsVertical(DataVertical.SOCIAL_POSTS)) {
            this.importerMap.put(DataVertical.SOCIAL_POSTS, new GenericImporter(SocialPostsSerializer::serialize, appCredentials, this.urlAppend(serviceConfig.getEndpoint(), "social-posts"), context.getMonitor()));
        }
        if (serviceConfig.supportsVertical(DataVertical.CALENDAR)) {
            this.importerMap.put(DataVertical.CALENDAR, new GenericImporter(CalendarSerializer::serialize, appCredentials, this.urlAppend(serviceConfig.getEndpoint(), "calendar"), context.getMonitor()));
        }
    }

    private URL urlAppend(URL base, String suffix) {
        try {
            Object path = base.getPath();
            if (!((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            path = (String)path + suffix;
            return base.toURI().resolve((String)path).toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException("Failed to build URL", e);
        }
    }

    private GenericTransferServiceConfig parseConfig(JsonNode config) throws JsonProcessingException {
        ObjectMapper om = new ObjectMapper();
        return (GenericTransferServiceConfig)om.treeToValue((TreeNode)config, GenericTransferServiceConfig.class);
    }

    public String getServiceId() {
        return "Generic";
    }

    public Exporter<?, ?> getExporter(DataVertical transferDataType) {
        throw new UnsupportedOperationException("Generic exporters aren't supported");
    }

    public Importer<?, ?> getImporter(DataVertical transferDataType) {
        return this.importerMap.get(transferDataType);
    }
}

