/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.generic;

import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.datatransferproject.datatransfer.generic.FavoriteInfoExportData;
import org.datatransferproject.datatransfer.generic.MediaItemExportData;
import org.datatransferproject.types.common.models.photos.PhotoModel;

@JsonTypeName(value="Photo")
class PhotoExportData
extends MediaItemExportData {
    private PhotoExportData(String name, String description, String albumId, ZonedDateTime uploadedTime, FavoriteInfoExportData favoriteInfo) {
        super(name, description, albumId, uploadedTime, favoriteInfo);
    }

    static PhotoExportData fromModel(PhotoModel model) {
        return new PhotoExportData(model.getName(), model.getDescription(), model.getAlbumId(), ZonedDateTime.ofInstant(model.getUploadedTime().toInstant(), ZoneOffset.UTC), FavoriteInfoExportData.fromModel(model.getFavoriteInfo()));
    }
}

