/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.generic;

import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.datatransferproject.datatransfer.generic.FavoriteInfoExportData;
import org.datatransferproject.datatransfer.generic.MediaItemExportData;
import org.datatransferproject.types.common.models.videos.VideoModel;

@JsonTypeName(value="Video")
class VideoExportData
extends MediaItemExportData {
    private VideoExportData(String name, String description, String albumId, ZonedDateTime uploadedTime, FavoriteInfoExportData favoriteInfo) {
        super(name, description, albumId, uploadedTime, favoriteInfo);
    }

    static VideoExportData fromModel(VideoModel model) {
        return new VideoExportData(model.getName(), model.getDescription(), model.getAlbumId(), ZonedDateTime.ofInstant(model.getUploadedTime().toInstant(), ZoneOffset.UTC), FavoriteInfoExportData.fromModel(model.getFavoriteInfo()));
    }
}

