/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.generic;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.datatransferproject.types.common.models.FavoriteInfo;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
@JsonTypeName(value="FavoriteInfo")
class FavoriteInfoExportData {
    @JsonProperty
    private final boolean favorite;
    @JsonProperty
    private final ZonedDateTime lastUpdateTime;

    private FavoriteInfoExportData(boolean favorite, ZonedDateTime lastUpdateTime) {
        this.favorite = favorite;
        this.lastUpdateTime = lastUpdateTime;
    }

    public static FavoriteInfoExportData fromModel(FavoriteInfo model) {
        return new FavoriteInfoExportData(model.getFavorited(), ZonedDateTime.ofInstant(model.getLastUpdateTime().toInstant(), ZoneOffset.UTC));
    }

    public boolean isFavorite() {
        return this.favorite;
    }

    public ZonedDateTime getLastUpdateTime() {
        return this.lastUpdateTime;
    }
}

