/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.generic;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.datatransferproject.datatransfer.generic.GenericTransferServiceVerticalConfig;
import org.datatransferproject.types.common.models.DataVertical;

class GenericTransferServiceConfig {
    private final String serviceId;
    private final URL endpoint;
    private final Set<GenericTransferServiceVerticalConfig> verticals;

    public GenericTransferServiceConfig(@JsonProperty(value="serviceId", required=true) String serviceId, @JsonProperty(value="endpoint", required=true) URL endpoint, @JsonProperty(value="verticals", required=true) List<GenericTransferServiceVerticalConfig> verticals) {
        this.serviceId = serviceId;
        this.endpoint = endpoint;
        this.verticals = new HashSet<GenericTransferServiceVerticalConfig>(verticals);
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public URL getEndpoint() {
        return this.endpoint;
    }

    public Set<GenericTransferServiceVerticalConfig> getVerticals() {
        return this.verticals;
    }

    public boolean supportsVertical(DataVertical vertical) {
        return this.verticals.stream().map(verticalConfig -> verticalConfig.getVertical()).collect(Collectors.toSet()).contains(vertical);
    }
}

