/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.google;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import org.datatransferproject.api.launcher.ExtensionContext;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.datatransfer.google.blogger.GoogleBloggerImporter;
import org.datatransferproject.datatransfer.google.common.GoogleCredentialFactory;
import org.datatransferproject.spi.cloud.storage.AppCredentialStore;
import org.datatransferproject.spi.transfer.extension.TransferExtension;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.types.common.models.DataVertical;
import org.datatransferproject.types.transfer.auth.AppCredentials;

public class BloggerTransferExtension
implements TransferExtension {
    private static final String SERVICE_ID = "GoogleBlogger";
    private static final ImmutableList<DataVertical> SUPPORTED_SERVICES = ImmutableList.of((Object)DataVertical.SOCIAL_POSTS);
    private ImmutableMap<DataVertical, Importer> importerMap;
    private ImmutableMap<DataVertical, Exporter> exporterMap;
    private boolean initialized = false;

    public String getServiceId() {
        return SERVICE_ID;
    }

    public Exporter<?, ?> getExporter(DataVertical transferDataType) {
        Preconditions.checkArgument((boolean)this.initialized);
        Preconditions.checkArgument((boolean)SUPPORTED_SERVICES.contains((Object)transferDataType));
        return (Exporter)this.exporterMap.get((Object)transferDataType);
    }

    public Importer<?, ?> getImporter(DataVertical transferDataType) {
        Preconditions.checkArgument((boolean)this.initialized);
        Preconditions.checkArgument((boolean)SUPPORTED_SERVICES.contains((Object)transferDataType));
        return (Importer)this.importerMap.get((Object)transferDataType);
    }

    public void initialize(ExtensionContext context) {
        AppCredentials appCredentials;
        if (this.initialized) {
            return;
        }
        Monitor monitor = context.getMonitor();
        try {
            appCredentials = ((AppCredentialStore)context.getService(AppCredentialStore.class)).getAppCredentials("GOOGLEBLOGGER_KEY", "GOOGLEBLOGGER_SECRET");
        }
        catch (IOException e) {
            monitor.info(() -> "Unable to retrieve Google AppCredentials. Did you set GOOGLEBLOGGER_KEY and GOOGLEBLOGGER_SECRET?", new Object[0]);
            return;
        }
        HttpTransport httpTransport = (HttpTransport)context.getService(HttpTransport.class);
        JsonFactory jsonFactory = (JsonFactory)context.getService(JsonFactory.class);
        GoogleCredentialFactory credentialFactory = new GoogleCredentialFactory(httpTransport, jsonFactory, appCredentials, monitor);
        ImmutableMap.Builder importerBuilder = ImmutableMap.builder();
        importerBuilder.put((Object)DataVertical.SOCIAL_POSTS, (Object)new GoogleBloggerImporter(credentialFactory));
        this.importerMap = importerBuilder.build();
        ImmutableMap.Builder exporterBuilder = ImmutableMap.builder();
        this.exporterMap = exporterBuilder.build();
        this.initialized = true;
    }
}

