/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.google.common.gphotos;

import com.google.common.base.Strings;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.types.common.DownloadableFile;
import org.datatransferproject.types.common.FolderItem;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class GPhotosUpload {
    private static final String ALBUMLESS_IDENTIFIER = "%s_ALBUMLESS_ITEMS";
    private UUID jobId;
    private IdempotentImportExecutor executor;
    private TokensAndUrlAuthData authData;
    private static final int BATCH_UPLOAD_SIZE = 49;

    public GPhotosUpload(UUID jobId, IdempotentImportExecutor executor, TokensAndUrlAuthData authData) {
        this.jobId = jobId;
        this.executor = executor;
        this.authData = authData;
    }

    public <T extends DownloadableFile> long uploadItemsViaBatching(Collection<T> items, ItemBatchUploader<T> importer) throws Exception {
        long bytes = 0L;
        if (items == null || items.size() <= 0) {
            return bytes;
        }
        Map<String, List<DownloadableFile>> itemsByAlbumId = items.stream().filter(item -> !this.executor.isKeyCached(item.getIdempotentId()) && item.getFolderId() != null).collect(Collectors.groupingBy(FolderItem::getFolderId));
        itemsByAlbumId.put(String.format(ALBUMLESS_IDENTIFIER, this.jobId), items.stream().filter(item -> !this.executor.isKeyCached(item.getIdempotentId()) && item.getFolderId() == null).collect(Collectors.toList()));
        for (Map.Entry<String, List<DownloadableFile>> albumEntry : itemsByAlbumId.entrySet()) {
            String originalAlbumId = albumEntry.getKey();
            String googleAlbumId = Strings.isNullOrEmpty((String)originalAlbumId) || originalAlbumId.equals(String.format(ALBUMLESS_IDENTIFIER, this.jobId)) ? null : (String)((Object)this.executor.getCachedValue(originalAlbumId));
            UnmodifiableIterator batches = Iterators.partition(albumEntry.getValue().iterator(), (int)49);
            while (batches.hasNext()) {
                long batchBytes = importer.uploadToAlbum(this.jobId, this.authData, (List)batches.next(), this.executor, googleAlbumId);
                bytes += batchBytes;
            }
        }
        return bytes;
    }

    @FunctionalInterface
    public static interface ItemBatchUploader<T> {
        public long uploadToAlbum(UUID var1, TokensAndUrlAuthData var2, List<T> var3, IdempotentImportExecutor var4, String var5) throws Exception;
    }
}

