/*
 * Copyright 2019 The Data Transfer Project Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.datatransferproject.datatransfer.google.mediaModels;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Date;

/** Metadata about a {@code MediaItem}. */
public class MediaMetadata implements Serializable {

  //Time when the media item was first created (not when it was uploaded to Google Photos).
  @JsonProperty("creationTime")
  private String creationTime;
  @JsonProperty("photo")
  private Photo photo;

  @JsonProperty("video")
  private Video video;

  public String getCreationTime() {
    return creationTime;
  }
  public Photo getPhoto() {
    return photo;
  }

  public Video getVideo() {
    return video;
  }

  public void setCreationTime(String creationTime) {
    this.creationTime = creationTime;
  }

  public void setPhoto(Photo photo) {
    this.photo = photo;
  }

  public void setVideo(Video video) {
    this.video = video;
  }
}
