/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.google;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import org.datatransferproject.api.launcher.ExtensionContext;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.datatransfer.google.calendar.GoogleCalendarExporter;
import org.datatransferproject.datatransfer.google.calendar.GoogleCalendarImporter;
import org.datatransferproject.datatransfer.google.common.GoogleCredentialFactory;
import org.datatransferproject.datatransfer.google.contacts.GoogleContactsExporter;
import org.datatransferproject.datatransfer.google.contacts.GoogleContactsImporter;
import org.datatransferproject.datatransfer.google.drive.DriveExporter;
import org.datatransferproject.datatransfer.google.drive.DriveImporter;
import org.datatransferproject.datatransfer.google.gplus.GooglePlusExporter;
import org.datatransferproject.datatransfer.google.mail.GoogleMailExporter;
import org.datatransferproject.datatransfer.google.mail.GoogleMailImporter;
import org.datatransferproject.datatransfer.google.media.GoogleMediaExporter;
import org.datatransferproject.datatransfer.google.music.GoogleMusicExporter;
import org.datatransferproject.datatransfer.google.music.GoogleMusicImporter;
import org.datatransferproject.datatransfer.google.photos.GooglePhotosExporter;
import org.datatransferproject.datatransfer.google.photos.GooglePhotosImporter;
import org.datatransferproject.datatransfer.google.tasks.GoogleTasksExporter;
import org.datatransferproject.datatransfer.google.tasks.GoogleTasksImporter;
import org.datatransferproject.datatransfer.google.videos.GoogleVideosExporter;
import org.datatransferproject.datatransfer.google.videos.GoogleVideosImporter;
import org.datatransferproject.spi.cloud.storage.AppCredentialStore;
import org.datatransferproject.spi.cloud.storage.JobStore;
import org.datatransferproject.spi.cloud.storage.TemporaryPerJobDataStore;
import org.datatransferproject.spi.transfer.extension.TransferExtension;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutorExtension;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.types.common.models.DataVertical;
import org.datatransferproject.types.transfer.auth.AppCredentials;

public class GoogleTransferExtension
implements TransferExtension {
    public static final String SERVICE_ID = "google";
    private static final ImmutableList<DataVertical> SUPPORTED_SERVICES = ImmutableList.of((Object)DataVertical.BLOBS, (Object)DataVertical.CALENDAR, (Object)DataVertical.CONTACTS, (Object)DataVertical.MAIL, (Object)DataVertical.PHOTOS, (Object)DataVertical.SOCIAL_POSTS, (Object)DataVertical.TASKS, (Object)DataVertical.VIDEOS, (Object)DataVertical.MEDIA, (Object)DataVertical.MUSIC);
    private ImmutableMap<DataVertical, Importer> importerMap;
    private ImmutableMap<DataVertical, Exporter> exporterMap;
    private boolean initialized = false;

    public String getServiceId() {
        return SERVICE_ID;
    }

    public Exporter<?, ?> getExporter(DataVertical transferDataType) {
        Preconditions.checkArgument((boolean)this.initialized);
        Preconditions.checkArgument((boolean)SUPPORTED_SERVICES.contains((Object)transferDataType));
        return (Exporter)this.exporterMap.get((Object)transferDataType);
    }

    public Importer<?, ?> getImporter(DataVertical transferDataType) {
        Preconditions.checkArgument((boolean)this.initialized);
        Preconditions.checkArgument((boolean)SUPPORTED_SERVICES.contains((Object)transferDataType));
        return (Importer)this.importerMap.get((Object)transferDataType);
    }

    public void initialize(ExtensionContext context) {
        AppCredentials appCredentials;
        if (this.initialized) {
            return;
        }
        JobStore jobStore = (JobStore)context.getService(JobStore.class);
        HttpTransport httpTransport = (HttpTransport)context.getService(HttpTransport.class);
        JsonFactory jsonFactory = (JsonFactory)context.getService(JsonFactory.class);
        try {
            appCredentials = ((AppCredentialStore)context.getService(AppCredentialStore.class)).getAppCredentials("GOOGLE_KEY", "GOOGLE_SECRET");
        }
        catch (IOException e) {
            Monitor monitor = context.getMonitor();
            monitor.info(() -> "Unable to retrieve Google AppCredentials. Did you set GOOGLE_KEY and GOOGLE_SECRET?", new Object[0]);
            return;
        }
        Monitor monitor = context.getMonitor();
        GoogleCredentialFactory credentialFactory = new GoogleCredentialFactory(httpTransport, jsonFactory, appCredentials, monitor);
        IdempotentImportExecutor idempotentImportExecutor = ((IdempotentImportExecutorExtension)context.getService(IdempotentImportExecutorExtension.class)).getRetryingIdempotentImportExecutor(context);
        boolean enableRetrying = (Boolean)context.getSetting("enableRetrying", (Object)false);
        ImmutableMap.Builder importerBuilder = ImmutableMap.builder();
        importerBuilder.put((Object)DataVertical.BLOBS, (Object)new DriveImporter(credentialFactory, (TemporaryPerJobDataStore)jobStore, monitor));
        importerBuilder.put((Object)DataVertical.CONTACTS, (Object)new GoogleContactsImporter(credentialFactory));
        importerBuilder.put((Object)DataVertical.CALENDAR, (Object)new GoogleCalendarImporter(credentialFactory));
        importerBuilder.put((Object)DataVertical.MAIL, (Object)new GoogleMailImporter(credentialFactory, monitor));
        importerBuilder.put((Object)DataVertical.TASKS, (Object)new GoogleTasksImporter(credentialFactory));
        importerBuilder.put((Object)DataVertical.PHOTOS, (Object)new GooglePhotosImporter(credentialFactory, jobStore, jsonFactory, monitor, (Double)context.getSetting("googleWritesPerSecond", (Object)1.0), idempotentImportExecutor, enableRetrying));
        importerBuilder.put((Object)DataVertical.VIDEOS, (Object)new GoogleVideosImporter(appCredentials, (TemporaryPerJobDataStore)jobStore, monitor));
        importerBuilder.put((Object)DataVertical.MUSIC, (Object)new GoogleMusicImporter(credentialFactory, jsonFactory, monitor, (Double)context.getSetting("googleWritesPerSecond", (Object)1.0)));
        this.importerMap = importerBuilder.build();
        ImmutableMap.Builder exporterBuilder = ImmutableMap.builder();
        exporterBuilder.put((Object)DataVertical.BLOBS, (Object)new DriveExporter(credentialFactory, (TemporaryPerJobDataStore)jobStore, monitor));
        exporterBuilder.put((Object)DataVertical.CONTACTS, (Object)new GoogleContactsExporter(credentialFactory));
        exporterBuilder.put((Object)DataVertical.CALENDAR, (Object)new GoogleCalendarExporter(credentialFactory));
        exporterBuilder.put((Object)DataVertical.MAIL, (Object)new GoogleMailExporter(credentialFactory));
        exporterBuilder.put((Object)DataVertical.SOCIAL_POSTS, (Object)new GooglePlusExporter(credentialFactory));
        exporterBuilder.put((Object)DataVertical.TASKS, (Object)new GoogleTasksExporter(credentialFactory, monitor));
        exporterBuilder.put((Object)DataVertical.PHOTOS, (Object)new GooglePhotosExporter(credentialFactory, jobStore, jsonFactory, monitor));
        exporterBuilder.put((Object)DataVertical.VIDEOS, (Object)new GoogleVideosExporter(credentialFactory, jobStore, jsonFactory, monitor));
        exporterBuilder.put((Object)DataVertical.MEDIA, (Object)new GoogleMediaExporter(credentialFactory, jobStore, jsonFactory, monitor, null, idempotentImportExecutor, enableRetrying));
        exporterBuilder.put((Object)DataVertical.MUSIC, (Object)new GoogleMusicExporter(credentialFactory, jsonFactory, monitor));
        this.exporterMap = exporterBuilder.build();
        this.initialized = true;
    }
}

