/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.google.calendar;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.util.DateTime;
import com.google.api.services.calendar.Calendar;
import com.google.api.services.calendar.model.Event;
import com.google.api.services.calendar.model.EventAttendee;
import com.google.api.services.calendar.model.EventDateTime;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.UUID;
import java.util.stream.Collectors;
import org.datatransferproject.datatransfer.google.common.GoogleCredentialFactory;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.provider.ImportResult;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.types.common.models.calendar.CalendarAttendeeModel;
import org.datatransferproject.types.common.models.calendar.CalendarContainerResource;
import org.datatransferproject.types.common.models.calendar.CalendarEventModel;
import org.datatransferproject.types.common.models.calendar.CalendarModel;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class GoogleCalendarImporter
implements Importer<TokensAndUrlAuthData, CalendarContainerResource> {
    private final GoogleCredentialFactory credentialFactory;
    private volatile Calendar calendarInterface;

    public GoogleCalendarImporter(GoogleCredentialFactory credentialFactory) {
        this(credentialFactory, null);
    }

    @VisibleForTesting
    GoogleCalendarImporter(GoogleCredentialFactory credentialFactory, Calendar calendarInterface) {
        this.credentialFactory = credentialFactory;
        this.calendarInterface = calendarInterface;
    }

    private static EventAttendee transformToEventAttendee(CalendarAttendeeModel attendee) {
        return new EventAttendee().setDisplayName(attendee.getDisplayName()).setEmail(attendee.getEmail()).setOptional(Boolean.valueOf(attendee.getOptional()));
    }

    private static EventDateTime getEventDateTime(CalendarEventModel.CalendarEventTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        EventDateTime eventDateTime = new EventDateTime();
        if (dateTime.isDateOnly()) {
            eventDateTime.setDate(new DateTime(true, dateTime.getDateTime().toEpochSecond() * 1000L, Integer.valueOf(dateTime.getDateTime().getOffset().getTotalSeconds() / 60)));
        } else {
            eventDateTime.setDateTime(new DateTime(dateTime.getDateTime().toEpochSecond() * 1000L, dateTime.getDateTime().getOffset().getTotalSeconds() / 60));
        }
        return eventDateTime;
    }

    static com.google.api.services.calendar.model.Calendar convertToGoogleCalendar(CalendarModel calendarModel) {
        return new com.google.api.services.calendar.model.Calendar().setSummary("Copy of - " + calendarModel.getName()).setDescription(calendarModel.getDescription());
    }

    static Event convertToGoogleCalendarEvent(CalendarEventModel eventModel) {
        Event event = new Event().setLocation(eventModel.getLocation()).setDescription(eventModel.getNotes()).setSummary(eventModel.getTitle()).setStart(GoogleCalendarImporter.getEventDateTime(eventModel.getStartTime())).setEnd(GoogleCalendarImporter.getEventDateTime(eventModel.getEndTime()));
        if (eventModel.getAttendees() != null) {
            event.setAttendees(eventModel.getAttendees().stream().map(GoogleCalendarImporter::transformToEventAttendee).collect(Collectors.toList()));
        }
        return event;
    }

    public ImportResult importItem(UUID jobId, IdempotentImportExecutor idempotentExecutor, TokensAndUrlAuthData authData, CalendarContainerResource data) throws Exception {
        for (CalendarModel calendarModel : data.getCalendars()) {
            idempotentExecutor.executeAndSwallowIOExceptions(calendarModel.getId(), calendarModel.getName(), () -> this.importSingleCalendar(authData, calendarModel));
        }
        for (CalendarEventModel eventModel : data.getEvents()) {
            idempotentExecutor.executeAndSwallowIOExceptions(Integer.toString(eventModel.hashCode()), eventModel.getNotes(), () -> this.importSingleEvent(idempotentExecutor, authData, eventModel));
        }
        return ImportResult.OK;
    }

    @VisibleForTesting
    String importSingleCalendar(TokensAndUrlAuthData authData, CalendarModel calendarModel) throws IOException {
        com.google.api.services.calendar.model.Calendar toInsert = GoogleCalendarImporter.convertToGoogleCalendar(calendarModel);
        com.google.api.services.calendar.model.Calendar calendarResult = (com.google.api.services.calendar.model.Calendar)this.getOrCreateCalendarInterface(authData).calendars().insert(toInsert).execute();
        return calendarResult.getId();
    }

    @VisibleForTesting
    String importSingleEvent(IdempotentImportExecutor idempotentImportExecutor, TokensAndUrlAuthData authData, CalendarEventModel eventModel) throws IOException {
        Event event = GoogleCalendarImporter.convertToGoogleCalendarEvent(eventModel);
        String newCalendarId = (String)((Object)idempotentImportExecutor.getCachedValue(eventModel.getCalendarId()));
        return ((Event)this.getOrCreateCalendarInterface(authData).events().insert(newCalendarId, event).execute()).getId();
    }

    private Calendar getOrCreateCalendarInterface(TokensAndUrlAuthData authData) {
        return this.calendarInterface == null ? this.makeCalendarInterface(authData) : this.calendarInterface;
    }

    private synchronized Calendar makeCalendarInterface(TokensAndUrlAuthData authData) {
        Credential credential = this.credentialFactory.createCredential(authData);
        return new Calendar.Builder(this.credentialFactory.getHttpTransport(), this.credentialFactory.getJsonFactory(), (HttpRequestInitializer)credential).setApplicationName("Portability").build();
    }
}

