/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.google.common;

import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialRefreshListener;
import com.google.api.client.auth.oauth2.RefreshTokenRequest;
import com.google.api.client.auth.oauth2.TokenErrorResponse;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.auth.oauth2.TokenResponseException;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import java.io.IOException;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.spi.transfer.types.InvalidTokenException;
import org.datatransferproject.types.transfer.auth.AppCredentials;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class GoogleCredentialFactory {
    private static final long EXPIRE_TIME_IN_SECONDS = 0L;
    private final HttpTransport httpTransport;
    private final JsonFactory jsonFactory;
    private final AppCredentials appCredentials;
    private final Monitor monitor;

    public GoogleCredentialFactory(HttpTransport httpTransport, JsonFactory jsonFactory, AppCredentials appCredentials, Monitor monitor) {
        this.httpTransport = httpTransport;
        this.jsonFactory = jsonFactory;
        this.appCredentials = appCredentials;
        this.monitor = monitor;
    }

    public HttpTransport getHttpTransport() {
        return this.httpTransport;
    }

    public JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    public Credential createCredential(TokensAndUrlAuthData authData) {
        return new Credential.Builder(BearerToken.authorizationHeaderAccessMethod()).setTransport(this.httpTransport).setJsonFactory(this.jsonFactory).setClientAuthentication((HttpExecuteInterceptor)new ClientParametersAuthentication(this.appCredentials.getKey(), this.appCredentials.getSecret())).setTokenServerEncodedUrl(authData.getTokenServerEncodedUrl()).addRefreshListener(new CredentialRefreshListener(){

            public void onTokenResponse(Credential credential, TokenResponse tokenResponse) throws IOException {
                GoogleCredentialFactory.this.monitor.info(() -> "Successfully refreshed token", new Object[0]);
            }

            public void onTokenErrorResponse(Credential credential, TokenErrorResponse tokenErrorResponse) throws IOException {
                GoogleCredentialFactory.this.monitor.info(() -> "Error while refreshing token: " + tokenErrorResponse.getError(), new Object[0]);
            }
        }).build().setAccessToken(authData.getAccessToken()).setRefreshToken(authData.getRefreshToken()).setExpiresInSeconds(Long.valueOf(0L));
    }

    public Credential refreshCredential(Credential credential) throws IOException, InvalidTokenException {
        try {
            TokenResponse tokenResponse = new RefreshTokenRequest(this.httpTransport, this.jsonFactory, new GenericUrl(credential.getTokenServerEncodedUrl()), credential.getRefreshToken()).setClientAuthentication(credential.getClientAuthentication()).setRequestInitializer(credential.getRequestInitializer()).execute();
            return credential.setFromTokenResponse(tokenResponse);
        }
        catch (TokenResponseException e) {
            TokenErrorResponse details = e.getDetails();
            if (details != null && details.getError().equals("invalid_grant")) {
                throw new InvalidTokenException("Unable to refresh token.", (Throwable)e);
            }
            throw e;
        }
    }
}

