/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.google.common;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.UUID;
import org.datatransferproject.spi.cloud.storage.JobStore;
import org.datatransferproject.types.transfer.errors.ErrorDetail;

public class GoogleErrorLogger {
    public static void logFailedItemErrors(JobStore jobStore, UUID jobId, ImmutableList<ErrorDetail> errorDetails) throws IOException {
        jobStore.addErrorsToJob(jobId, errorDetails);
    }

    public static ErrorDetail createErrorDetail(String idempotentId, String title, Exception e, boolean canSkip) {
        return ErrorDetail.builder().setId(idempotentId).setTitle(title).setException(Throwables.getStackTraceAsString((Throwable)e)).setCanSkip(canSkip).build();
    }
}

