/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.google.contacts;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.services.people.v1.PeopleService;
import com.google.api.services.people.v1.model.EmailAddress;
import com.google.api.services.people.v1.model.FieldMetadata;
import com.google.api.services.people.v1.model.GetPeopleResponse;
import com.google.api.services.people.v1.model.ListConnectionsResponse;
import com.google.api.services.people.v1.model.Name;
import com.google.api.services.people.v1.model.Person;
import com.google.api.services.people.v1.model.PhoneNumber;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import ezvcard.VCard;
import ezvcard.io.json.JCardWriter;
import ezvcard.property.Address;
import ezvcard.property.Email;
import ezvcard.property.StructuredName;
import ezvcard.property.Telephone;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.datatransferproject.datatransfer.google.common.GoogleCredentialFactory;
import org.datatransferproject.spi.transfer.provider.ExportResult;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.types.ContinuationData;
import org.datatransferproject.types.common.ExportInformation;
import org.datatransferproject.types.common.PaginationData;
import org.datatransferproject.types.common.StringPaginationToken;
import org.datatransferproject.types.common.models.DataModel;
import org.datatransferproject.types.common.models.contacts.ContactsModelWrapper;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class GoogleContactsExporter
implements Exporter<TokensAndUrlAuthData, ContactsModelWrapper> {
    private final GoogleCredentialFactory credentialFactory;
    private volatile PeopleService peopleService;

    public GoogleContactsExporter(GoogleCredentialFactory credentialFactory) {
        this.credentialFactory = credentialFactory;
        this.peopleService = null;
    }

    @VisibleForTesting
    GoogleContactsExporter(PeopleService peopleService) {
        this.credentialFactory = null;
        this.peopleService = peopleService;
    }

    @VisibleForTesting
    static VCard convert(Person person) {
        VCard vCard = new VCard();
        Preconditions.checkArgument((boolean)GoogleContactsExporter.atLeastOneNamePresent(person.getNames()), (Object)"At least one name must be present");
        GoogleContactsExporter.convertToVCardNamesAndPopulate(vCard, person.getNames());
        if (person.getAddresses() != null) {
            person.getAddresses().forEach(a -> vCard.addAddress(GoogleContactsExporter.convertToVCardAddress(a)));
        }
        if (person.getPhoneNumbers() != null) {
            person.getPhoneNumbers().forEach(n -> vCard.addTelephoneNumber(GoogleContactsExporter.convertToVCardTelephone(n)));
        }
        if (person.getEmailAddresses() != null) {
            person.getEmailAddresses().forEach(e -> vCard.addEmail(GoogleContactsExporter.convertToVCardEmail(e)));
        }
        return vCard;
    }

    private static void convertToVCardNamesAndPopulate(VCard vCard, List<Name> personNames) {
        StructuredName primaryStructuredName = null;
        LinkedList<StructuredName> alternateStructuredNames = new LinkedList<StructuredName>();
        for (Name personName : personNames) {
            StructuredName structuredName = GoogleContactsExporter.convertToVCardNameSingle(personName);
            Boolean isNamePrimary = personName.getMetadata().getPrimary();
            if (primaryStructuredName == null && isNamePrimary != null && isNamePrimary.booleanValue()) {
                primaryStructuredName = structuredName;
                continue;
            }
            alternateStructuredNames.add(structuredName);
        }
        if (primaryStructuredName == null) {
            primaryStructuredName = (StructuredName)alternateStructuredNames.pop();
        }
        vCard.addProperty(primaryStructuredName);
        vCard.addPropertyAlt(StructuredName.class, alternateStructuredNames);
    }

    private static StructuredName convertToVCardNameSingle(Name personName) {
        StructuredName structuredName = new StructuredName();
        structuredName.setFamily(personName.getFamilyName());
        structuredName.setGiven(personName.getGivenName());
        structuredName.setParameter("Source_type", personName.getMetadata().getSource().getType());
        return structuredName;
    }

    private static Address convertToVCardAddress(com.google.api.services.people.v1.model.Address personAddress) {
        Address vCardAddress = new Address();
        vCardAddress.setCountry(personAddress.getCountry());
        vCardAddress.setRegion(personAddress.getRegion());
        vCardAddress.setLocality(personAddress.getCity());
        vCardAddress.setPostalCode(personAddress.getPostalCode());
        vCardAddress.setStreetAddress(personAddress.getStreetAddress());
        vCardAddress.setPoBox(personAddress.getPoBox());
        vCardAddress.setExtendedAddress(personAddress.getExtendedAddress());
        vCardAddress.setPref(Integer.valueOf(GoogleContactsExporter.getPref(personAddress.getMetadata())));
        return vCardAddress;
    }

    private static Telephone convertToVCardTelephone(PhoneNumber personNumber) {
        Telephone telephone = new Telephone(personNumber.getValue());
        telephone.setPref(Integer.valueOf(GoogleContactsExporter.getPref(personNumber.getMetadata())));
        return telephone;
    }

    private static Email convertToVCardEmail(EmailAddress personEmail) {
        Email email = new Email(personEmail.getValue());
        email.setPref(Integer.valueOf(GoogleContactsExporter.getPref(personEmail.getMetadata())));
        return email;
    }

    private static int getPref(FieldMetadata metadata) {
        return metadata.getPrimary() != false ? 1 : 2;
    }

    private static boolean atLeastOneNamePresent(List<Name> personNames) {
        return personNames.size() >= 1 && !personNames.get(0).isEmpty();
    }

    @VisibleForTesting
    static String makeVCardString(List<VCard> vCardList) throws IOException {
        StringWriter stringWriter = new StringWriter();
        JCardWriter jCardWriter = new JCardWriter((Writer)stringWriter);
        for (VCard vCardProperties : vCardList) {
            jCardWriter.write(vCardProperties);
        }
        jCardWriter.flush();
        return stringWriter.toString();
    }

    public ExportResult<ContactsModelWrapper> export(UUID jobId, TokensAndUrlAuthData authData, Optional<ExportInformation> exportInformation) {
        if (exportInformation.isPresent()) {
            StringPaginationToken stringPaginationToken = (StringPaginationToken)exportInformation.get().getPaginationData();
            return this.exportContacts(authData, Optional.ofNullable(stringPaginationToken));
        }
        return this.exportContacts(authData, Optional.empty());
    }

    private ExportResult<ContactsModelWrapper> exportContacts(TokensAndUrlAuthData authData, Optional<PaginationData> pageData) {
        try {
            PeopleService.People.Connections.List connectionsListRequest = this.getOrCreatePeopleService(authData).people().connections().list("people/me");
            if (pageData.isPresent()) {
                StringPaginationToken paginationToken = (StringPaginationToken)pageData.get();
                connectionsListRequest.setPageToken(paginationToken.getToken());
            }
            ListConnectionsResponse response = (ListConnectionsResponse)connectionsListRequest.setPersonFields("emailAddresses,names,phoneNumbers,addresses").execute();
            List peopleList = response.getConnections();
            List resourceNames = peopleList.stream().map(Person::getResourceName).collect(Collectors.toList());
            GetPeopleResponse batchResponse = (GetPeopleResponse)this.getOrCreatePeopleService(authData).people().getBatchGet().setResourceNames(resourceNames).setPersonFields("emailAddresses,names,phoneNumbers,addresses").execute();
            List personResponseList = batchResponse.getResponses();
            List<VCard> vCards = personResponseList.stream().map(a -> GoogleContactsExporter.convert(a.getPerson())).collect(Collectors.toList());
            StringPaginationToken nextPageData = null;
            if (response.getNextPageToken() != null) {
                nextPageData = new StringPaginationToken(response.getNextPageToken());
            }
            ContinuationData continuationData = new ContinuationData(nextPageData);
            ContactsModelWrapper wrapper = new ContactsModelWrapper(GoogleContactsExporter.makeVCardString(vCards));
            ExportResult.ResultType resultType = ExportResult.ResultType.CONTINUE;
            if (nextPageData == null) {
                resultType = ExportResult.ResultType.END;
            }
            return new ExportResult(resultType, (DataModel)wrapper, continuationData);
        }
        catch (IOException e) {
            return new ExportResult((Throwable)e);
        }
    }

    private PeopleService getOrCreatePeopleService(TokensAndUrlAuthData authData) {
        return this.peopleService == null ? this.makePeopleService(authData) : this.peopleService;
    }

    private synchronized PeopleService makePeopleService(TokensAndUrlAuthData authData) {
        Credential credential = this.credentialFactory.createCredential(authData);
        return new PeopleService.Builder(this.credentialFactory.getHttpTransport(), this.credentialFactory.getJsonFactory(), (HttpRequestInitializer)credential).setApplicationName("Portability").build();
    }
}

