/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.google.drive;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import com.google.api.services.drive.model.FileList;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.datatransfer.google.common.GoogleCredentialFactory;
import org.datatransferproject.spi.cloud.storage.TemporaryPerJobDataStore;
import org.datatransferproject.spi.transfer.provider.ExportResult;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.types.ContinuationData;
import org.datatransferproject.types.common.ExportInformation;
import org.datatransferproject.types.common.StringPaginationToken;
import org.datatransferproject.types.common.models.DataModel;
import org.datatransferproject.types.common.models.blob.BlobbyStorageContainerResource;
import org.datatransferproject.types.common.models.blob.DigitalDocumentWrapper;
import org.datatransferproject.types.common.models.blob.DtpDigitalDocument;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public final class DriveExporter
implements Exporter<TokensAndUrlAuthData, BlobbyStorageContainerResource> {
    private static final String DRIVE_QUERY_FORMAT = "'%s' in parents and trashed=false";
    static final String FOLDER_MIME_TYPE = "application/vnd.google-apps.folder";
    private static final String FUSION_TABLE_MIME_TYPE = "application/vnd.google-apps.fusiontable";
    private static final String MAP_MIME_TYPE = "application/vnd.google-apps.map";
    private static final ImmutableMap<String, String> EXPORT_FORMATS = ImmutableMap.builder().put((Object)"application/vnd.google-apps.document", (Object)"application/vnd.openxmlformats-officedocument.wordprocessingml.document").put((Object)"application/vnd.google-apps.spreadsheet", (Object)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet").put((Object)"application/vnd.google-apps.drawing", (Object)"image/svg+xml").put((Object)"application/vnd.google-apps.presentation", (Object)"application/vnd.openxmlformats-officedocument.presentationml.presentation").put((Object)"application/vnd.google-apps.script", (Object)"application/vnd.google-apps.script+json").put((Object)"application/vnd.google-apps.jam", (Object)"application/pdf").put((Object)"application/vnd.google-apps.form", (Object)"application/zip").put((Object)"application/vnd.google-apps.site", (Object)"text/plain").build();
    private final GoogleCredentialFactory credentialFactory;
    private final TemporaryPerJobDataStore jobStore;
    private final Monitor monitor;
    private Drive driveInterface;

    public DriveExporter(GoogleCredentialFactory credentialFactory, TemporaryPerJobDataStore jobStore, Monitor monitor) {
        this.credentialFactory = (GoogleCredentialFactory)Preconditions.checkNotNull((Object)credentialFactory, (Object)"Credential Factory can't be null");
        this.jobStore = (TemporaryPerJobDataStore)Preconditions.checkNotNull((Object)jobStore, (Object)"Job store can't be null");
        this.monitor = monitor;
    }

    public ExportResult<BlobbyStorageContainerResource> export(UUID jobId, TokensAndUrlAuthData authData, Optional<ExportInformation> optionalExportInformation) throws Exception {
        Drive driveInterface = this.getDriveInterface(authData);
        Drive.Files.List driveListOperation = driveInterface.files().list();
        String parentId = "root";
        if (optionalExportInformation.isPresent()) {
            ExportInformation exportInformation = optionalExportInformation.get();
            if (exportInformation.getPaginationData() != null) {
                StringPaginationToken paginationToken = (StringPaginationToken)exportInformation.getPaginationData();
                driveListOperation.setPageToken(paginationToken.getToken());
            }
            if (exportInformation.getContainerResource() != null) {
                BlobbyStorageContainerResource parent = (BlobbyStorageContainerResource)exportInformation.getContainerResource();
                parentId = parent.getId();
            }
        }
        driveListOperation.setFields("files(id, name, modifiedTime, mimeType)").setQ(String.format(DRIVE_QUERY_FORMAT, parentId));
        ArrayList<DigitalDocumentWrapper> files = new ArrayList<DigitalDocumentWrapper>();
        ArrayList<BlobbyStorageContainerResource> folders = new ArrayList<BlobbyStorageContainerResource>();
        FileList fileList = (FileList)driveListOperation.execute();
        for (File file : fileList.getFiles()) {
            if (FOLDER_MIME_TYPE.equals(file.getMimeType())) {
                folders.add(new BlobbyStorageContainerResource(file.getName(), file.getId(), null, null));
            } else if (FUSION_TABLE_MIME_TYPE.equals(file.getMimeType())) {
                this.monitor.info(() -> "Exporting of fusion tables is not yet supported: " + String.valueOf(file), new Object[0]);
            } else if (MAP_MIME_TYPE.equals(file.getMimeType())) {
                this.monitor.info(() -> "Exporting of maps is not yet supported: " + String.valueOf(file), new Object[0]);
            } else {
                try {
                    InputStream inputStream;
                    String newMimeType = file.getMimeType();
                    if (EXPORT_FORMATS.containsKey((Object)file.getMimeType())) {
                        newMimeType = (String)EXPORT_FORMATS.get((Object)file.getMimeType());
                        inputStream = driveInterface.files().export(file.getId(), newMimeType).executeMedia().getContent();
                    } else {
                        inputStream = driveInterface.files().get(file.getId()).setAlt("media").executeMedia().getContent();
                    }
                    this.jobStore.create(jobId, file.getId(), inputStream);
                    files.add(new DigitalDocumentWrapper(new DtpDigitalDocument(file.getName(), file.getModifiedTime().toStringRfc3339(), newMimeType), file.getMimeType(), file.getId()));
                }
                catch (Exception e) {
                    this.monitor.severe(() -> "Error exporting " + String.valueOf(file), new Object[]{e});
                }
            }
            this.monitor.info(() -> "Exported " + String.valueOf(file), new Object[0]);
        }
        ExportResult.ResultType resultType = DriveExporter.isDone(fileList) ? ExportResult.ResultType.END : ExportResult.ResultType.CONTINUE;
        BlobbyStorageContainerResource result = new BlobbyStorageContainerResource(null, parentId, files, folders);
        StringPaginationToken paginationToken = null;
        if (!Strings.isNullOrEmpty((String)fileList.getNextPageToken())) {
            paginationToken = new StringPaginationToken(fileList.getNextPageToken());
        }
        ContinuationData continuationData = new ContinuationData(paginationToken);
        folders.forEach(arg_0 -> ((ContinuationData)continuationData).addContainerResource(arg_0));
        return new ExportResult(resultType, (DataModel)result, continuationData);
    }

    private static boolean isDone(FileList fileList) {
        return fileList.getFiles().isEmpty() || Strings.isNullOrEmpty((String)fileList.getNextPageToken());
    }

    private synchronized Drive getDriveInterface(TokensAndUrlAuthData authData) {
        if (this.driveInterface == null) {
            this.driveInterface = DriveExporter.makeDriveInterface(authData, this.credentialFactory);
        }
        return this.driveInterface;
    }

    static synchronized Drive makeDriveInterface(TokensAndUrlAuthData authData, GoogleCredentialFactory credentialFactory) {
        Credential credential = credentialFactory.createCredential(authData);
        return new Drive.Builder(credentialFactory.getHttpTransport(), credentialFactory.getJsonFactory(), (HttpRequestInitializer)credential).setApplicationName("Portability").build();
    }
}

