/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.google.gplus;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.services.plus.Plus;
import com.google.api.services.plus.model.Activity;
import com.google.api.services.plus.model.ActivityFeed;
import com.google.api.services.plus.model.Place;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.datatransferproject.datatransfer.google.common.GoogleCredentialFactory;
import org.datatransferproject.spi.transfer.provider.ExportResult;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.types.ContinuationData;
import org.datatransferproject.types.common.ExportInformation;
import org.datatransferproject.types.common.PaginationData;
import org.datatransferproject.types.common.StringPaginationToken;
import org.datatransferproject.types.common.models.social.SocialActivityActor;
import org.datatransferproject.types.common.models.social.SocialActivityAttachment;
import org.datatransferproject.types.common.models.social.SocialActivityAttachmentType;
import org.datatransferproject.types.common.models.social.SocialActivityContainerResource;
import org.datatransferproject.types.common.models.social.SocialActivityLocation;
import org.datatransferproject.types.common.models.social.SocialActivityModel;
import org.datatransferproject.types.common.models.social.SocialActivityType;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class GooglePlusExporter
implements Exporter<TokensAndUrlAuthData, SocialActivityContainerResource> {
    private final GoogleCredentialFactory credentialFactory;
    private volatile Plus plusService;

    public GooglePlusExporter(GoogleCredentialFactory credentialFactory) {
        this.credentialFactory = credentialFactory;
        this.plusService = null;
    }

    @VisibleForTesting
    GooglePlusExporter(Plus plusService) {
        this.credentialFactory = null;
        this.plusService = plusService;
    }

    public ExportResult<SocialActivityContainerResource> export(UUID jobId, TokensAndUrlAuthData authData, Optional<ExportInformation> exportInformation) throws IOException {
        Plus plus = this.getOrCreatePeopleService(authData);
        Plus.Activities.List listActivities = plus.activities().list("me", "public");
        if (exportInformation.isPresent()) {
            StringPaginationToken pageToken = (StringPaginationToken)exportInformation.get().getPaginationData();
            listActivities.setPageToken(pageToken.getToken());
        }
        ActivityFeed activityFeed = (ActivityFeed)listActivities.execute();
        List activities = activityFeed.getItems();
        ContinuationData continuationData = null;
        SocialActivityContainerResource results = null;
        if (activities != null && !activities.isEmpty()) {
            ArrayList<SocialActivityModel> activityModels = new ArrayList<SocialActivityModel>();
            Activity.Actor actor = ((Activity)activities.get(0)).getActor();
            SocialActivityActor parsedActor = new SocialActivityActor(actor.getUrl(), actor.getDisplayName(), actor.getUrl());
            if (!Strings.isNullOrEmpty((String)activityFeed.getNextPageToken())) {
                continuationData = new ContinuationData((PaginationData)new StringPaginationToken(activityFeed.getNextPageToken()));
            }
            for (Activity activity : activities) {
                try {
                    activityModels.add(this.postToActivityModel(activity));
                }
                catch (RuntimeException e) {
                    throw new IOException("Problem exporting: " + String.valueOf(activity), e);
                }
            }
            results = new SocialActivityContainerResource(jobId.toString(), parsedActor, activityModels);
        }
        return new ExportResult(continuationData == null ? ExportResult.ResultType.END : ExportResult.ResultType.CONTINUE, results, continuationData);
    }

    private SocialActivityModel postToActivityModel(Activity activity) {
        String contentString = activity.getObject().getOriginalContent();
        ArrayList<SocialActivityAttachment> activityAttachments = new ArrayList<SocialActivityAttachment>();
        switch (activity.getVerb()) {
            case "post": {
                for (Activity.PlusObject.Attachments attachment : activity.getObject().getAttachments()) {
                    if (attachment.getObjectType().equals("article")) {
                        activityAttachments.add(new SocialActivityAttachment(SocialActivityAttachmentType.LINK, attachment.getUrl(), attachment.getDisplayName(), attachment.getContent()));
                        continue;
                    }
                    if (attachment.getObjectType().equals("photo")) {
                        activityAttachments.add(new SocialActivityAttachment(SocialActivityAttachmentType.IMAGE, attachment.getFullImage().getUrl(), attachment.getDisplayName(), attachment.getContent()));
                        continue;
                    }
                    if (attachment.getObjectType().equals("album")) {
                        for (Activity.PlusObject.Attachments.Thumbnails image : attachment.getThumbnails()) {
                            activityAttachments.add(new SocialActivityAttachment(SocialActivityAttachmentType.IMAGE, image.getImage().getUrl(), image.getDescription(), "Original G+ Image: " + image.getUrl() + " from album: " + attachment.getUrl()));
                        }
                        continue;
                    }
                    throw new IllegalArgumentException("Don't know how to export attachment " + attachment.getObjectType());
                }
                return new SocialActivityModel(activity.getId(), Instant.ofEpochMilli(activity.getPublished().getValue()), SocialActivityType.POST, activityAttachments, null, activity.getTitle(), contentString, activity.getUrl());
            }
            case "checkin": {
                Place location = activity.getLocation();
                return new SocialActivityModel(activity.getId(), Instant.ofEpochMilli(activity.getPublished().getValue()), SocialActivityType.CHECKIN, null, new SocialActivityLocation(location.getDisplayName(), location.getPosition().getLongitude().doubleValue(), location.getPosition().getLatitude().doubleValue()), activity.getPlaceName(), contentString, null);
            }
        }
        throw new IllegalArgumentException("Don't know how to export " + String.valueOf(activity));
    }

    private Plus getOrCreatePeopleService(TokensAndUrlAuthData authData) {
        return this.plusService == null ? this.makePlusService(authData) : this.plusService;
    }

    private synchronized Plus makePlusService(TokensAndUrlAuthData authData) {
        Credential credential = this.credentialFactory.createCredential(authData);
        return new Plus.Builder(this.credentialFactory.getHttpTransport(), this.credentialFactory.getJsonFactory(), (HttpRequestInitializer)credential).setApplicationName("Portability").build();
    }
}

