/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.google.tasks;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.util.DateTime;
import com.google.api.services.tasks.Tasks;
import com.google.api.services.tasks.model.Task;
import com.google.api.services.tasks.model.TaskList;
import com.google.common.annotations.VisibleForTesting;
import java.util.UUID;
import org.datatransferproject.datatransfer.google.common.GoogleCredentialFactory;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.provider.ImportResult;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.types.common.models.tasks.TaskContainerResource;
import org.datatransferproject.types.common.models.tasks.TaskListModel;
import org.datatransferproject.types.common.models.tasks.TaskModel;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class GoogleTasksImporter
implements Importer<TokensAndUrlAuthData, TaskContainerResource> {
    private final GoogleCredentialFactory credentialFactory;
    private Tasks tasksClient;

    public GoogleTasksImporter(GoogleCredentialFactory credentialFactory) {
        this(credentialFactory, null);
    }

    @VisibleForTesting
    GoogleTasksImporter(GoogleCredentialFactory credentialFactory, Tasks tasksClient) {
        this.credentialFactory = credentialFactory;
        this.tasksClient = tasksClient;
    }

    public ImportResult importItem(UUID jobId, IdempotentImportExecutor idempotentImportExecutor, TokensAndUrlAuthData authData, TaskContainerResource data) throws Exception {
        Tasks tasksService = this.getOrCreateTasksService(authData);
        for (TaskListModel oldTasksList : data.getLists()) {
            TaskList newTaskList = new TaskList().setTitle("Imported copy - " + oldTasksList.getName());
            idempotentImportExecutor.executeAndSwallowIOExceptions(oldTasksList.getId(), oldTasksList.getName(), () -> ((TaskList)tasksService.tasklists().insert(newTaskList).execute()).getId());
        }
        for (TaskModel oldTask : data.getTasks()) {
            Task newTask = new Task().setTitle(oldTask.getText()).setNotes(oldTask.getNotes());
            if (oldTask.getCompletedTime() != null) {
                newTask.setCompleted(new DateTime(oldTask.getCompletedTime().toEpochMilli()));
            }
            if (oldTask.getDueTime() != null) {
                newTask.setDue(new DateTime(oldTask.getDueTime().toEpochMilli()));
            }
            if (!idempotentImportExecutor.isKeyCached(oldTask.getTaskListId())) continue;
            String newTaskListId = (String)((Object)idempotentImportExecutor.getCachedValue(oldTask.getTaskListId()));
            idempotentImportExecutor.executeAndSwallowIOExceptions(oldTask.getTaskListId() + oldTask.getText(), oldTask.getText(), () -> ((Task)tasksService.tasks().insert(newTaskListId, newTask).execute()).getId());
        }
        return new ImportResult(ImportResult.ResultType.OK);
    }

    private Tasks getOrCreateTasksService(TokensAndUrlAuthData authData) {
        return this.tasksClient == null ? this.makeTasksService(authData) : this.tasksClient;
    }

    private synchronized Tasks makeTasksService(TokensAndUrlAuthData authData) {
        Credential credential = this.credentialFactory.createCredential(authData);
        return new Tasks.Builder(this.credentialFactory.getHttpTransport(), this.credentialFactory.getJsonFactory(), (HttpRequestInitializer)credential).setApplicationName("Portability").build();
    }
}

