/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.google.blogger;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.InputStreamContent;
import com.google.api.client.util.DateTime;
import com.google.api.services.blogger.Blogger;
import com.google.api.services.blogger.model.Blog;
import com.google.api.services.blogger.model.BlogList;
import com.google.api.services.blogger.model.Post;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import com.google.api.services.drive.model.Permission;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.datatransferproject.datatransfer.google.common.GoogleCredentialFactory;
import org.datatransferproject.spi.cloud.connection.ConnectionProvider;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.provider.ImportResult;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.types.common.models.social.SocialActivityActor;
import org.datatransferproject.types.common.models.social.SocialActivityAttachment;
import org.datatransferproject.types.common.models.social.SocialActivityAttachmentType;
import org.datatransferproject.types.common.models.social.SocialActivityContainerResource;
import org.datatransferproject.types.common.models.social.SocialActivityModel;
import org.datatransferproject.types.common.models.social.SocialActivityType;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class GoogleBloggerImporter
implements Importer<TokensAndUrlAuthData, SocialActivityContainerResource> {
    private final GoogleCredentialFactory credentialFactory;
    private Blogger blogger;
    private Drive driveInterface;

    public GoogleBloggerImporter(GoogleCredentialFactory credentialFactory) {
        this.credentialFactory = credentialFactory;
        this.blogger = null;
        this.driveInterface = null;
    }

    public ImportResult importItem(UUID jobId, IdempotentImportExecutor idempotentExecutor, TokensAndUrlAuthData authData, SocialActivityContainerResource data) throws Exception {
        Blogger blogger = this.getOrCreateBloggerService(authData);
        BlogList blogList = (BlogList)blogger.blogs().listByUser("self").execute();
        String blogId = ((Blog)blogList.getItems().get(0)).getId();
        for (SocialActivityModel activity : data.getActivities()) {
            if (activity.getType() != SocialActivityType.NOTE && activity.getType() != SocialActivityType.POST) continue;
            try {
                this.insertActivity(idempotentExecutor, data.getActor(), activity, blogId, authData);
            }
            catch (IOException | RuntimeException e) {
                throw new IOException("Couldn't import: " + String.valueOf(activity), e);
            }
        }
        return new ImportResult(ImportResult.ResultType.OK);
    }

    private void insertActivity(IdempotentImportExecutor idempotentExecutor, SocialActivityActor actor, SocialActivityModel activity, String blogId, TokensAndUrlAuthData authData) throws Exception {
        Object content = activity.getContent() == null ? "" : activity.getContent();
        Collection linkAttachments = activity.getAttachments().stream().filter(attachment -> attachment.getType() == SocialActivityAttachmentType.LINK).collect(Collectors.toList());
        Collection imageAttachments = activity.getAttachments().stream().filter(attachment -> attachment.getType() == SocialActivityAttachmentType.IMAGE).collect(Collectors.toList());
        for (SocialActivityAttachment attachment2 : linkAttachments) {
            content = "<a href=\"" + attachment2.getUrl() + "\">" + attachment2.getName() + "</a>\n</hr>\n" + (String)content;
        }
        if (!imageAttachments.isEmpty()) {
            Drive driveInterface = this.getOrCreateDriveService(authData);
            String folderId = (String)((Object)idempotentExecutor.executeOrThrowException("MainAlbum", "Photo Album", () -> this.createAlbumFolder(driveInterface)));
            for (SocialActivityAttachment image : imageAttachments) {
                try {
                    String newImgSrc = (String)((Object)idempotentExecutor.executeAndSwallowIOExceptions(image.toString(), "Image", () -> this.uploadImage(image, driveInterface, folderId)));
                    content = (String)content + "\n<hr/><img src=\"" + newImgSrc + "\">";
                }
                catch (RuntimeException e) {
                    throw new IOException("Couldn't import: " + String.valueOf(imageAttachments), e);
                }
            }
        }
        String title = "";
        if (activity.getTitle() != null && !Strings.isNullOrEmpty((String)activity.getTitle())) {
            title = activity.getTitle();
        }
        Post post = new Post().setTitle("Imported post: " + title).setContent((String)content);
        if (actor != null) {
            Post.Author author = new Post.Author();
            if (!Strings.isNullOrEmpty((String)actor.getName())) {
                author.setDisplayName(actor.getName());
            }
            if (!Strings.isNullOrEmpty((String)actor.getUrl())) {
                author.setUrl(actor.getUrl());
            }
            post.setAuthor(author);
        }
        if (activity.getPublished() != null) {
            post.setPublished(new DateTime(activity.getPublished().toEpochMilli()));
        }
        idempotentExecutor.executeAndSwallowIOExceptions(title, title, () -> ((Post)this.getOrCreateBloggerService(authData).posts().insert(blogId, post).setIsDraft(Boolean.valueOf(true)).execute()).getId());
    }

    private String createAlbumFolder(Drive driveInterface) throws IOException {
        File fileMetadata = new File();
        LocalDate localDate = LocalDate.now();
        fileMetadata.setName("(Public)Imported Images on: " + localDate.toString());
        fileMetadata.setMimeType("application/vnd.google-apps.folder");
        File folder = (File)driveInterface.files().create(fileMetadata).setFields("id").execute();
        driveInterface.permissions().create(folder.getId(), new Permission().setRole("reader").setType("anyone").setAllowFileDiscovery(Boolean.valueOf(false))).execute();
        return folder.getId();
    }

    private String uploadImage(SocialActivityAttachment imageObject, Drive driveService, String parentFolderId) throws IOException {
        String url = imageObject.getUrl().toString();
        Object description = imageObject.getName() != null ? imageObject.getName() : "Imported photo from: " + url;
        HttpURLConnection conn = ConnectionProvider.getConnection((String)url);
        InputStream inputStream = conn.getInputStream();
        File driveFile = new File().setName((String)description).setParents((List)ImmutableList.of((Object)parentFolderId));
        InputStreamContent content = new InputStreamContent(null, inputStream);
        File newFile = (File)driveService.files().create(driveFile, (AbstractInputStreamContent)content).setFields("id").execute();
        return "https://drive.google.com/thumbnail?id=" + newFile.getId();
    }

    private Blogger getOrCreateBloggerService(TokensAndUrlAuthData authData) {
        return this.blogger == null ? this.makeBloggerService(authData) : this.blogger;
    }

    private synchronized Blogger makeBloggerService(TokensAndUrlAuthData authData) {
        Credential credential = this.credentialFactory.createCredential(authData);
        return new Blogger.Builder(this.credentialFactory.getHttpTransport(), this.credentialFactory.getJsonFactory(), (HttpRequestInitializer)credential).setApplicationName("Portability").build();
    }

    private synchronized Drive getOrCreateDriveService(TokensAndUrlAuthData authData) {
        return this.driveInterface == null ? (this.driveInterface = this.makeDriveService(authData)) : this.driveInterface;
    }

    private synchronized Drive makeDriveService(TokensAndUrlAuthData authData) {
        Credential credential = this.credentialFactory.createCredential(authData);
        return new Drive.Builder(this.credentialFactory.getHttpTransport(), this.credentialFactory.getJsonFactory(), (HttpRequestInitializer)credential).setApplicationName("Portability").build();
    }
}

