/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.google.drive;

import com.google.api.client.auth.oauth2.TokenErrorResponse;
import com.google.api.client.auth.oauth2.TokenResponseException;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.InputStreamContent;
import com.google.api.client.util.DateTime;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.datatransfer.google.common.GoogleCredentialFactory;
import org.datatransferproject.datatransfer.google.drive.DriveExporter;
import org.datatransferproject.spi.cloud.storage.TemporaryPerJobDataStore;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.provider.ImportResult;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.spi.transfer.types.DestinationMemoryFullException;
import org.datatransferproject.spi.transfer.types.InvalidTokenException;
import org.datatransferproject.types.common.models.blob.BlobbyStorageContainerResource;
import org.datatransferproject.types.common.models.blob.DigitalDocumentWrapper;
import org.datatransferproject.types.common.models.blob.DtpDigitalDocument;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public final class DriveImporter
implements Importer<TokensAndUrlAuthData, BlobbyStorageContainerResource> {
    private static final String ROOT_FOLDER_ID = "root-id";
    private static final String ROOT_FOLDER_FORMAT_STRING = "transfer-%s";
    private final GoogleCredentialFactory credentialFactory;
    private final TemporaryPerJobDataStore jobStore;
    private final Monitor monitor;
    private Drive driveInterface;

    public DriveImporter(GoogleCredentialFactory credentialFactory, TemporaryPerJobDataStore jobStore, Monitor monitor) {
        this.credentialFactory = credentialFactory;
        this.jobStore = (TemporaryPerJobDataStore)Preconditions.checkNotNull((Object)jobStore, (Object)"Job store can't be null");
        this.monitor = monitor;
    }

    public ImportResult importItem(UUID jobId, IdempotentImportExecutor idempotentExecutor, TokensAndUrlAuthData authData, BlobbyStorageContainerResource data) throws Exception {
        Drive driveInterface = this.getDriveInterface(authData);
        String parentId = Strings.isNullOrEmpty((String)data.getId()) || "root".equals(data.getId()) ? (String)((Object)idempotentExecutor.executeOrThrowException(ROOT_FOLDER_ID, data.getName(), () -> this.importSingleFolder(driveInterface, this.getRootFolderName(), null))) : (String)((Object)idempotentExecutor.getCachedValue(data.getId()));
        for (BlobbyStorageContainerResource folder : data.getFolders()) {
            idempotentExecutor.executeAndSwallowIOExceptions(folder.getId(), folder.getName(), () -> this.importSingleFolder(driveInterface, folder.getName(), parentId));
        }
        for (DigitalDocumentWrapper file : data.getFiles()) {
            idempotentExecutor.executeAndSwallowIOExceptions(Integer.toString(file.hashCode()), file.getDtpDigitalDocument().getName(), () -> this.importSingleFile(jobId, driveInterface, file, parentId));
        }
        return ImportResult.OK;
    }

    private String importSingleFolder(Drive driveInterface, String folderName, String parentId) throws IOException, InvalidTokenException, DestinationMemoryFullException {
        File newFolder = new File().setName(folderName).setMimeType("application/vnd.google-apps.folder");
        if (!Strings.isNullOrEmpty((String)parentId)) {
            newFolder.setParents((List)ImmutableList.of((Object)parentId));
        }
        try {
            return ((File)driveInterface.files().create(newFolder).execute()).getId();
        }
        catch (TokenResponseException e) {
            TokenErrorResponse details = e.getDetails();
            if (details != null && details.getError().equals("invalid_grant")) {
                throw new InvalidTokenException("Unable to refresh token.", (Throwable)e);
            }
            throw e;
        }
        catch (GoogleJsonResponseException e) {
            if (e.getStatusCode() == 403 && e.getMessage().contains("storage quota has been exceeded")) {
                throw new DestinationMemoryFullException("Destination Google Drive storage was full", (Throwable)e);
            }
            throw e;
        }
    }

    private String importSingleFile(UUID jobId, Drive driveInterface, DigitalDocumentWrapper file, String parentId) throws IOException, InvalidTokenException, DestinationMemoryFullException {
        InputStreamContent content = new InputStreamContent(null, this.jobStore.getStream(jobId, file.getCachedContentId()).getStream());
        DtpDigitalDocument dtpDigitalDocument = file.getDtpDigitalDocument();
        File driveFile = new File().setName(dtpDigitalDocument.getName());
        if (!Strings.isNullOrEmpty((String)parentId)) {
            driveFile.setParents((List)ImmutableList.of((Object)parentId));
        }
        if (!Strings.isNullOrEmpty((String)dtpDigitalDocument.getDateModified())) {
            driveFile.setModifiedTime(DateTime.parseRfc3339((String)dtpDigitalDocument.getDateModified()));
        }
        if (!Strings.isNullOrEmpty((String)file.getOriginalEncodingFormat()) && file.getOriginalEncodingFormat().startsWith("application/vnd.google-apps.")) {
            driveFile.setMimeType(file.getOriginalEncodingFormat());
        }
        try {
            return ((File)driveInterface.files().create(driveFile, (AbstractInputStreamContent)content).execute()).getId();
        }
        catch (TokenResponseException e) {
            TokenErrorResponse details = e.getDetails();
            if (details != null && details.getError().equals("invalid_grant")) {
                throw new InvalidTokenException("Unable to refresh token.", (Throwable)e);
            }
            throw e;
        }
        catch (GoogleJsonResponseException e) {
            if (e.getStatusCode() == 403 && e.getMessage().contains("storage quota has been exceeded")) {
                throw new DestinationMemoryFullException("Destination Google Drive storage was full", (Throwable)e);
            }
            throw e;
        }
    }

    private synchronized Drive getDriveInterface(TokensAndUrlAuthData authData) {
        if (this.driveInterface == null) {
            this.driveInterface = DriveExporter.makeDriveInterface(authData, this.credentialFactory);
        }
        return this.driveInterface;
    }

    private String getRootFolderName() {
        return String.format(ROOT_FOLDER_FORMAT_STRING, new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(new Date()));
    }
}

