/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.google.calendar;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.services.calendar.Calendar;
import com.google.api.services.calendar.model.CalendarList;
import com.google.api.services.calendar.model.CalendarListEntry;
import com.google.api.services.calendar.model.Event;
import com.google.api.services.calendar.model.EventAttendee;
import com.google.api.services.calendar.model.EventDateTime;
import com.google.api.services.calendar.model.Events;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.datatransferproject.datatransfer.google.common.GoogleCredentialFactory;
import org.datatransferproject.spi.transfer.provider.ExportResult;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.types.ContinuationData;
import org.datatransferproject.types.common.ExportInformation;
import org.datatransferproject.types.common.PaginationData;
import org.datatransferproject.types.common.StringPaginationToken;
import org.datatransferproject.types.common.models.ContainerResource;
import org.datatransferproject.types.common.models.DataModel;
import org.datatransferproject.types.common.models.IdOnlyContainerResource;
import org.datatransferproject.types.common.models.calendar.CalendarAttendeeModel;
import org.datatransferproject.types.common.models.calendar.CalendarContainerResource;
import org.datatransferproject.types.common.models.calendar.CalendarEventModel;
import org.datatransferproject.types.common.models.calendar.CalendarModel;
import org.datatransferproject.types.common.models.calendar.RecurrenceRule;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class GoogleCalendarExporter
implements Exporter<TokensAndUrlAuthData, CalendarContainerResource> {
    private final GoogleCredentialFactory credentialFactory;
    private volatile Calendar calendarInterface;

    public GoogleCalendarExporter(GoogleCredentialFactory credentialFactory) {
        this(credentialFactory, null);
    }

    @VisibleForTesting
    GoogleCalendarExporter(GoogleCredentialFactory credentialFactory, Calendar calendarInterface) {
        this.credentialFactory = credentialFactory;
        this.calendarInterface = calendarInterface;
    }

    private static CalendarAttendeeModel transformToModelAttendee(EventAttendee attendee) {
        return new CalendarAttendeeModel(attendee.getDisplayName(), attendee.getEmail(), Boolean.TRUE.equals(attendee.getOptional()));
    }

    private static CalendarEventModel.CalendarEventTime getEventTime(EventDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        OffsetDateTime offsetDateTime = dateTime.getDate() == null ? OffsetDateTime.parse(dateTime.getDateTime().toString()) : OffsetDateTime.from(LocalDate.parse(dateTime.getDate().toString()).atStartOfDay(ZoneId.of("UTC")));
        return new CalendarEventModel.CalendarEventTime(offsetDateTime, dateTime.getDate() != null);
    }

    private static RecurrenceRule getRecurrenceRule(List<String> ruleStrings) {
        RecurrenceRule.Builder ruleBuilder = new RecurrenceRule.Builder();
        block10: for (String st : ruleStrings) {
            Preconditions.checkArgument((boolean)st.contains(":"), (Object)("Recurrence entry " + st + " cannot be parsed"));
            String[] split = st.split("[:;]", 2);
            String type = split[0];
            String value = split[1];
            switch (type) {
                case "RRULE": {
                    ruleBuilder.setRRule(RecurrenceRule.parseRRuleString((String)value));
                    continue block10;
                }
                case "RDATE": {
                    ruleBuilder.setRDate(RecurrenceRule.parseRDateString((String)value));
                    continue block10;
                }
                case "EXDATE": {
                    ruleBuilder.setExDate(RecurrenceRule.parseExDateString((String)value));
                    continue block10;
                }
            }
            throw new IllegalArgumentException("Recurrence entry " + st + " is not recognizable as an RRULE, RDATE, or EXDATE");
        }
        return ruleBuilder.build();
    }

    private static CalendarModel convertToCalendarModel(CalendarListEntry calendarData) {
        return new CalendarModel(calendarData.getId(), calendarData.getSummary(), calendarData.getDescription());
    }

    private static CalendarEventModel convertToCalendarEventModel(String id, Event eventData) {
        List attendees = eventData.getAttendees();
        List recurrenceRulesStrings = eventData.getRecurrence();
        return new CalendarEventModel(id, eventData.getDescription(), eventData.getSummary(), attendees == null ? null : attendees.stream().map(GoogleCalendarExporter::transformToModelAttendee).collect(Collectors.toList()), eventData.getLocation(), GoogleCalendarExporter.getEventTime(eventData.getStart()), GoogleCalendarExporter.getEventTime(eventData.getEnd()), recurrenceRulesStrings == null ? null : GoogleCalendarExporter.getRecurrenceRule(recurrenceRulesStrings));
    }

    public ExportResult<CalendarContainerResource> export(UUID jobId, TokensAndUrlAuthData authData, Optional<ExportInformation> exportInformation) {
        if (!exportInformation.isPresent()) {
            return this.exportCalendars(authData, Optional.empty());
        }
        StringPaginationToken paginationToken = (StringPaginationToken)exportInformation.get().getPaginationData();
        if (paginationToken != null && paginationToken.getToken().startsWith("calendar:")) {
            return this.exportCalendars(authData, Optional.of(paginationToken));
        }
        IdOnlyContainerResource idOnlyContainerResource = (IdOnlyContainerResource)exportInformation.get().getContainerResource();
        Optional<StringPaginationToken> pageData = Optional.ofNullable(paginationToken);
        return this.getCalendarEvents(authData, idOnlyContainerResource.getId(), pageData);
    }

    private ExportResult<CalendarContainerResource> exportCalendars(TokensAndUrlAuthData authData, Optional<PaginationData> pageData) {
        CalendarList listResult;
        try {
            Calendar.CalendarList.List listRequest = this.getOrCreateCalendarInterface(authData).calendarList().list();
            if (pageData.isPresent()) {
                StringPaginationToken paginationToken = (StringPaginationToken)pageData.get();
                Preconditions.checkState((boolean)paginationToken.getToken().startsWith("calendar:"), (Object)"Token is not applicable");
                listRequest.setPageToken(((StringPaginationToken)pageData.get()).getToken().substring("calendar:".length()));
            }
            listResult = (CalendarList)listRequest.execute();
        }
        catch (IOException e) {
            return new ExportResult((Throwable)e);
        }
        StringPaginationToken nextPageData = null;
        if (listResult.getNextPageToken() != null) {
            nextPageData = new StringPaginationToken("calendar:" + listResult.getNextPageToken());
        }
        ContinuationData continuationData = new ContinuationData(nextPageData);
        ArrayList<CalendarModel> calendarModels = new ArrayList<CalendarModel>(listResult.getItems().size());
        for (CalendarListEntry calendarData : listResult.getItems()) {
            CalendarModel model = GoogleCalendarExporter.convertToCalendarModel(calendarData);
            continuationData.addContainerResource((ContainerResource)new IdOnlyContainerResource(calendarData.getId()));
            calendarModels.add(model);
        }
        CalendarContainerResource calendarContainerResource = new CalendarContainerResource(calendarModels, null);
        ExportResult.ResultType resultType = ExportResult.ResultType.CONTINUE;
        if (calendarModels.isEmpty()) {
            resultType = ExportResult.ResultType.END;
        }
        return new ExportResult(resultType, (DataModel)calendarContainerResource, continuationData);
    }

    private ExportResult<CalendarContainerResource> getCalendarEvents(TokensAndUrlAuthData authData, String id, Optional<PaginationData> pageData) {
        Events listResult;
        try {
            Calendar.Events.List listRequest = this.getOrCreateCalendarInterface(authData).events().list(id).setMaxAttendees(Integer.valueOf(100));
            if (pageData.isPresent()) {
                StringPaginationToken paginationToken = (StringPaginationToken)pageData.get();
                Preconditions.checkState((boolean)paginationToken.getToken().startsWith("event:"), (Object)"Token is not applicable");
                listRequest.setPageToken(((StringPaginationToken)pageData.get()).getToken().substring("event:".length()));
            }
            listResult = (Events)listRequest.execute();
        }
        catch (IOException e) {
            return new ExportResult((Throwable)e);
        }
        StringPaginationToken nextPageData = null;
        if (listResult.getNextPageToken() != null) {
            nextPageData = new StringPaginationToken("event:" + listResult.getNextPageToken());
        }
        ContinuationData continuationData = new ContinuationData(nextPageData);
        ArrayList<CalendarEventModel> eventModels = new ArrayList<CalendarEventModel>(listResult.getItems().size());
        for (Event eventData : listResult.getItems()) {
            CalendarEventModel model = GoogleCalendarExporter.convertToCalendarEventModel(id, eventData);
            eventModels.add(model);
        }
        CalendarContainerResource calendarContainerResource = new CalendarContainerResource(null, eventModels);
        ExportResult.ResultType resultType = ExportResult.ResultType.CONTINUE;
        if (nextPageData == null) {
            resultType = ExportResult.ResultType.END;
        }
        return new ExportResult(resultType, (DataModel)calendarContainerResource, continuationData);
    }

    private Calendar getOrCreateCalendarInterface(TokensAndUrlAuthData authData) {
        return this.calendarInterface == null ? this.makeCalendarInterface(authData) : this.calendarInterface;
    }

    private synchronized Calendar makeCalendarInterface(TokensAndUrlAuthData authData) {
        Credential credential = this.credentialFactory.createCredential(authData);
        return new Calendar.Builder(this.credentialFactory.getHttpTransport(), this.credentialFactory.getJsonFactory(), (HttpRequestInitializer)credential).setApplicationName("Portability").build();
    }
}

