/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.google.mail;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.services.gmail.Gmail;
import com.google.api.services.gmail.model.Label;
import com.google.api.services.gmail.model.ListLabelsResponse;
import com.google.api.services.gmail.model.Message;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.datatransfer.google.common.GoogleCredentialFactory;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.provider.ImportResult;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.types.common.models.mail.MailContainerModel;
import org.datatransferproject.types.common.models.mail.MailContainerResource;
import org.datatransferproject.types.common.models.mail.MailMessageModel;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class GoogleMailImporter
implements Importer<TokensAndUrlAuthData, MailContainerResource> {
    @VisibleForTesting
    static final String USER = "me";
    @VisibleForTesting
    static final String LABEL = "DTP-migrated";
    private GoogleCredentialFactory credentialFactory;
    private final Gmail gmail;
    private final Monitor monitor;

    public GoogleMailImporter(GoogleCredentialFactory credentialFactory, Monitor monitor) {
        this(credentialFactory, null, monitor);
    }

    @VisibleForTesting
    GoogleMailImporter(GoogleCredentialFactory credentialFactory, Gmail gmail, Monitor monitor) {
        this.credentialFactory = credentialFactory;
        this.gmail = gmail;
        this.monitor = monitor;
    }

    public ImportResult importItem(UUID id, IdempotentImportExecutor idempotentExecutor, TokensAndUrlAuthData authData, MailContainerResource data) throws Exception {
        Supplier<Map<String, String>> allDestinationLabels = this.allDestinationLabelsSupplier(authData);
        this.importLabels(authData, idempotentExecutor, allDestinationLabels, data.getFolders());
        this.importDTPLabel(authData, idempotentExecutor, allDestinationLabels);
        this.importLabelsForMessages(authData, idempotentExecutor, allDestinationLabels, data.getMessages());
        this.importMessages(authData, idempotentExecutor, data.getMessages());
        return ImportResult.OK;
    }

    private void importLabels(TokensAndUrlAuthData authData, IdempotentImportExecutor idempotentExecutor, Supplier<Map<String, String>> allDestinationLabels, Collection<MailContainerModel> folders) throws Exception {
        for (MailContainerModel mailContainerModel : folders) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)mailContainerModel.getName()) ? 1 : 0) != 0);
            String exportedLabelName = mailContainerModel.getName();
            idempotentExecutor.executeAndSwallowIOExceptions(exportedLabelName, "Label - " + exportedLabelName, () -> {
                String importerLabelId = (String)((Map)allDestinationLabels.get()).get(mailContainerModel.getName());
                if (importerLabelId == null) {
                    importerLabelId = this.createImportedLabelId(authData, mailContainerModel.getName());
                }
                return importerLabelId;
            });
        }
    }

    private void importDTPLabel(TokensAndUrlAuthData authData, IdempotentImportExecutor idempotentExecutor, Supplier<Map<String, String>> allDestinationLabels) throws Exception {
        idempotentExecutor.executeAndSwallowIOExceptions(LABEL, LABEL, () -> {
            String migratedLabelId = (String)((Map)allDestinationLabels.get()).get(LABEL);
            if (migratedLabelId == null) {
                migratedLabelId = this.createImportedLabelId(authData, LABEL);
            }
            return migratedLabelId;
        });
    }

    private void importLabelsForMessages(TokensAndUrlAuthData authData, IdempotentImportExecutor idempotentExecutor, Supplier<Map<String, String>> allDestinationLabels, Collection<MailMessageModel> messages) throws Exception {
        for (MailMessageModel mailMessageModel : messages) {
            for (String exportedLabelName : mailMessageModel.getContainerIds()) {
                idempotentExecutor.executeAndSwallowIOExceptions(exportedLabelName, exportedLabelName, () -> {
                    String importerLabelId = (String)((Map)allDestinationLabels.get()).get(exportedLabelName);
                    if (importerLabelId == null) {
                        importerLabelId = this.createImportedLabelId(authData, exportedLabelName);
                    }
                    return importerLabelId;
                });
            }
        }
    }

    private void importMessages(TokensAndUrlAuthData authData, IdempotentImportExecutor idempotentExecutor, Collection<MailMessageModel> messages) throws Exception {
        for (MailMessageModel mailMessageModel : messages) {
            idempotentExecutor.executeAndSwallowIOExceptions(mailMessageModel.toString(), "Mail message: " + mailMessageModel.getRawString().substring(0, Math.min(50, mailMessageModel.getRawString().length())), () -> {
                ImmutableList.Builder importedLabelIds = ImmutableList.builder();
                for (String exportedLabelIdOrName : mailMessageModel.getContainerIds()) {
                    String importedLabelId = (String)((Object)idempotentExecutor.getCachedValue(exportedLabelIdOrName));
                    if (importedLabelId != null) {
                        importedLabelIds.add((Object)exportedLabelIdOrName);
                        continue;
                    }
                    this.monitor.debug(() -> "labels should have been added prior to importing messages", new Object[0]);
                }
                Message newMessage = new Message().setRaw(mailMessageModel.getRawString()).setLabelIds((List)importedLabelIds.build());
                return ((Message)this.getOrCreateGmail(authData).users().messages().insert(USER, newMessage).execute()).getId();
            });
        }
    }

    private Supplier<Map<String, String>> allDestinationLabelsSupplier(TokensAndUrlAuthData authData) {
        return () -> {
            ListLabelsResponse response;
            try {
                response = (ListLabelsResponse)this.getOrCreateGmail(authData).users().labels().list(USER).execute();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to list labels for user", e);
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Label label : response.getLabels()) {
                builder.put((Object)label.getName(), (Object)label.getId());
            }
            return builder.build();
        };
    }

    private String createImportedLabelId(TokensAndUrlAuthData authData, String labelName) throws IOException {
        Label newLabel = new Label().setName(labelName).setLabelListVisibility("labelShow").setMessageListVisibility("show");
        return ((Label)this.getOrCreateGmail(authData).users().labels().create(USER, newLabel).execute()).getId();
    }

    private Gmail getOrCreateGmail(TokensAndUrlAuthData authData) {
        return this.gmail == null ? this.makeGmailService(authData) : this.gmail;
    }

    private synchronized Gmail makeGmailService(TokensAndUrlAuthData authData) {
        Credential credential = this.credentialFactory.createCredential(authData);
        return new Gmail.Builder(this.credentialFactory.getHttpTransport(), this.credentialFactory.getJsonFactory(), (HttpRequestInitializer)credential).setApplicationName("Portability").build();
    }
}

