/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.google.tasks;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.services.tasks.Tasks;
import com.google.api.services.tasks.model.TaskList;
import com.google.api.services.tasks.model.TaskLists;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.datatransfer.google.common.GoogleCredentialFactory;
import org.datatransferproject.spi.transfer.provider.ExportResult;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.types.ContinuationData;
import org.datatransferproject.types.common.ExportInformation;
import org.datatransferproject.types.common.PaginationData;
import org.datatransferproject.types.common.StringPaginationToken;
import org.datatransferproject.types.common.models.DataModel;
import org.datatransferproject.types.common.models.IdOnlyContainerResource;
import org.datatransferproject.types.common.models.tasks.TaskContainerResource;
import org.datatransferproject.types.common.models.tasks.TaskListModel;
import org.datatransferproject.types.common.models.tasks.TaskModel;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class GoogleTasksExporter
implements Exporter<TokensAndUrlAuthData, TaskContainerResource> {
    private static final long PAGE_SIZE = 50L;
    private final GoogleCredentialFactory credentialFactory;
    private final Monitor monitor;
    private volatile Tasks tasksClient;

    public GoogleTasksExporter(GoogleCredentialFactory credentialFactory, Monitor monitor) {
        this.credentialFactory = credentialFactory;
        this.monitor = monitor;
    }

    @VisibleForTesting
    GoogleTasksExporter(GoogleCredentialFactory credentialFactory, Tasks tasksClient, Monitor monitor) {
        this(credentialFactory, monitor);
        this.tasksClient = tasksClient;
    }

    public ExportResult<TaskContainerResource> export(UUID jobId, TokensAndUrlAuthData authData, Optional<ExportInformation> exportInformation) {
        Tasks tasksService = this.getOrCreateTasksService(authData);
        IdOnlyContainerResource resource = exportInformation.isPresent() ? (IdOnlyContainerResource)exportInformation.get().getContainerResource() : null;
        PaginationData paginationData = exportInformation.isPresent() ? exportInformation.get().getPaginationData() : null;
        try {
            if (resource != null) {
                return this.getTasks(tasksService, resource, Optional.ofNullable(paginationData));
            }
            return this.getTasksList(tasksService, Optional.ofNullable(paginationData));
        }
        catch (Exception e) {
            this.monitor.severe(() -> "Error occurred trying to retrieve task", new Object[]{e});
            return new ExportResult((Throwable)e);
        }
    }

    private ExportResult<TaskContainerResource> getTasks(Tasks tasksService, IdOnlyContainerResource resource, Optional<PaginationData> paginationData) throws IOException {
        Tasks.TasksOperations.List query = tasksService.tasks().list(resource.getId()).setMaxResults(Long.valueOf(50L));
        if (paginationData.isPresent()) {
            query.setPageToken(((StringPaginationToken)paginationData.get()).getToken());
        }
        com.google.api.services.tasks.model.Tasks result = (com.google.api.services.tasks.model.Tasks)query.execute();
        List newTasks = result.getItems().stream().map(t -> new TaskModel(resource.getId(), t.getTitle(), t.getNotes(), t.getCompleted() != null ? Instant.ofEpochMilli(t.getCompleted().getValue()) : null, t.getDue() != null ? Instant.ofEpochMilli(t.getDue().getValue()) : null)).collect(Collectors.toList());
        StringPaginationToken newPage = null;
        ExportResult.ResultType resultType = ExportResult.ResultType.END;
        if (result.getNextPageToken() != null) {
            newPage = new StringPaginationToken(result.getNextPageToken());
            resultType = ExportResult.ResultType.CONTINUE;
        }
        TaskContainerResource taskContainerResource = new TaskContainerResource(null, newTasks);
        return new ExportResult(resultType, (DataModel)taskContainerResource, new ContinuationData((PaginationData)newPage));
    }

    private ExportResult<TaskContainerResource> getTasksList(Tasks tasksService, Optional<PaginationData> paginationData) throws IOException {
        ImmutableList newResources;
        Tasks.Tasklists.List query = tasksService.tasklists().list().setMaxResults(Long.valueOf(50L));
        if (paginationData.isPresent()) {
            query.setPageToken(((StringPaginationToken)paginationData.get()).getToken());
        }
        TaskLists result = (TaskLists)query.execute();
        ImmutableList.Builder newTaskListsBuilder = ImmutableList.builder();
        ImmutableList.Builder newResourcesBuilder = ImmutableList.builder();
        for (TaskList taskList : result.getItems()) {
            newTaskListsBuilder.add((Object)new TaskListModel(taskList.getId(), taskList.getTitle()));
            newResourcesBuilder.add((Object)new IdOnlyContainerResource(taskList.getId()));
        }
        StringPaginationToken newPage = null;
        ExportResult.ResultType resultType = ExportResult.ResultType.END;
        if (result.getNextPageToken() != null) {
            newPage = new StringPaginationToken(result.getNextPageToken());
            resultType = ExportResult.ResultType.CONTINUE;
        }
        if (!(newResources = newResourcesBuilder.build()).isEmpty()) {
            resultType = ExportResult.ResultType.CONTINUE;
        }
        TaskContainerResource taskContainerResource = new TaskContainerResource((Collection)newTaskListsBuilder.build(), null);
        ContinuationData continuationData = new ContinuationData((PaginationData)newPage);
        newResourcesBuilder.build().forEach(arg_0 -> ((ContinuationData)continuationData).addContainerResource(arg_0));
        return new ExportResult(resultType, (DataModel)taskContainerResource, continuationData);
    }

    private Tasks getOrCreateTasksService(TokensAndUrlAuthData authData) {
        return this.tasksClient == null ? this.makeTasksService(authData) : this.tasksClient;
    }

    private synchronized Tasks makeTasksService(TokensAndUrlAuthData authData) {
        Credential credential = this.credentialFactory.createCredential(authData);
        return new Tasks.Builder(this.credentialFactory.getHttpTransport(), this.credentialFactory.getJsonFactory(), (HttpRequestInitializer)credential).setApplicationName("Portability").build();
    }
}

