/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.google.music;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.json.JsonFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.protobuf.Duration;
import com.google.protobuf.util.Durations;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.datatransfer.google.common.GoogleCredentialFactory;
import org.datatransferproject.datatransfer.google.music.GoogleMusicHttpApi;
import org.datatransferproject.datatransfer.google.musicModels.BatchPlaylistItemRequest;
import org.datatransferproject.datatransfer.google.musicModels.BatchPlaylistItemResponse;
import org.datatransferproject.datatransfer.google.musicModels.GoogleArtist;
import org.datatransferproject.datatransfer.google.musicModels.GooglePlaylist;
import org.datatransferproject.datatransfer.google.musicModels.GooglePlaylistItem;
import org.datatransferproject.datatransfer.google.musicModels.GoogleRelease;
import org.datatransferproject.datatransfer.google.musicModels.GoogleTrack;
import org.datatransferproject.datatransfer.google.musicModels.ImportPlaylistItemRequest;
import org.datatransferproject.datatransfer.google.musicModels.NewPlaylistItemResult;
import org.datatransferproject.datatransfer.google.musicModels.Status;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.provider.ImportResult;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.spi.transfer.types.CopyException;
import org.datatransferproject.types.common.models.music.MusicContainerResource;
import org.datatransferproject.types.common.models.music.MusicGroup;
import org.datatransferproject.types.common.models.music.MusicPlaylist;
import org.datatransferproject.types.common.models.music.MusicPlaylistItem;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class GoogleMusicImporter
implements Importer<TokensAndUrlAuthData, MusicContainerResource> {
    private static final int PLAYLIST_ITEM_BATCH_SIZE = 49;
    private final GoogleCredentialFactory credentialFactory;
    private final JsonFactory jsonFactory;
    private volatile GoogleMusicHttpApi musicHttpApi;
    private final Map<UUID, GoogleMusicHttpApi> musicHttpApisMap;
    private final Monitor monitor;
    private final double writesPerSecond;

    public GoogleMusicImporter(GoogleCredentialFactory credentialFactory, JsonFactory jsonFactory, Monitor monitor, double writesPerSecond) {
        this(credentialFactory, jsonFactory, null, new HashMap<UUID, GoogleMusicHttpApi>(), monitor, writesPerSecond);
    }

    @VisibleForTesting
    GoogleMusicImporter(GoogleCredentialFactory credentialFactory, JsonFactory jsonFactory, GoogleMusicHttpApi musicHttpApi, Map<UUID, GoogleMusicHttpApi> musicHttpApisMap, Monitor monitor, double writesPerSecond) {
        this.credentialFactory = credentialFactory;
        this.jsonFactory = jsonFactory;
        this.musicHttpApi = musicHttpApi;
        this.musicHttpApisMap = musicHttpApisMap;
        this.monitor = monitor;
        this.writesPerSecond = writesPerSecond;
    }

    public ImportResult importItem(UUID jobId, IdempotentImportExecutor idempotentImportExecutor, TokensAndUrlAuthData authData, MusicContainerResource data) throws Exception {
        if (data == null) {
            return ImportResult.OK;
        }
        for (MusicPlaylist playlist : data.getPlaylists()) {
            idempotentImportExecutor.executeAndSwallowIOExceptions(playlist.getId(), playlist.getTitle(), () -> this.importSinglePlaylist(jobId, authData, playlist));
        }
        this.importPlaylistItems(data.getPlaylistItems(), idempotentImportExecutor, jobId, authData);
        return ImportResult.OK;
    }

    @VisibleForTesting
    String importSinglePlaylist(UUID jobId, TokensAndUrlAuthData authData, MusicPlaylist inputPlaylist) throws IOException, CopyException {
        GooglePlaylist googlePlaylist = new GooglePlaylist();
        googlePlaylist.setDescription(inputPlaylist.getDescription());
        googlePlaylist.setTitle(inputPlaylist.getTitle());
        this.getOrCreateMusicInterface(jobId, authData).importPlaylist(googlePlaylist, inputPlaylist.getId());
        return inputPlaylist.getId();
    }

    void importPlaylistItems(List<MusicPlaylistItem> playlistItems, IdempotentImportExecutor executor, UUID jobId, TokensAndUrlAuthData authData) throws Exception {
        if (playlistItems != null && !playlistItems.isEmpty()) {
            Map<String, List<MusicPlaylistItem>> playlistItemsByPlaylist = playlistItems.stream().filter(playlistItem -> !executor.isKeyCached(playlistItem.toString())).collect(Collectors.groupingBy(MusicPlaylistItem::getPlaylistId));
            for (Map.Entry<String, List<MusicPlaylistItem>> playlistEntry : playlistItemsByPlaylist.entrySet()) {
                String originalPlaylistId = playlistEntry.getKey();
                UnmodifiableIterator batches = Iterators.partition(playlistEntry.getValue().iterator(), (int)49);
                while (batches.hasNext()) {
                    this.importPlaylistItemBatch(jobId, authData, (List)batches.next(), executor, originalPlaylistId);
                }
            }
        }
    }

    private void importPlaylistItemBatch(UUID jobId, TokensAndUrlAuthData authData, List<MusicPlaylistItem> playlistItems, IdempotentImportExecutor executor, String playlistId) throws Exception {
        if (!executor.isKeyCached(playlistId)) {
            for (MusicPlaylistItem playlistItem : playlistItems) {
                executor.executeAndSwallowIOExceptions(playlistItem.toString(), playlistItem.toString(), () -> {
                    throw new IOException(String.format("Fail to create Playlist %s for PlaylistItem : %s", playlistId, playlistItem));
                });
            }
            return;
        }
        ArrayList<ImportPlaylistItemRequest> createPlaylistItemRequests = new ArrayList<ImportPlaylistItemRequest>();
        for (MusicPlaylistItem playlistItem : playlistItems) {
            createPlaylistItemRequests.add(this.buildImportPlaylistItemRequest(playlistItem, playlistId));
        }
        BatchPlaylistItemRequest batchRequest = new BatchPlaylistItemRequest(createPlaylistItemRequests, playlistId);
        BatchPlaylistItemResponse responsePlaylistItem = this.getOrCreateMusicInterface(jobId, authData).importPlaylistItems(batchRequest);
        for (int i = 0; i < responsePlaylistItem.getResults().length; ++i) {
            NewPlaylistItemResult playlistItemResult = responsePlaylistItem.getResults()[i];
            executor.executeAndSwallowIOExceptions(playlistItems.get(i).toString(), playlistItems.get(i).toString(), () -> this.summarizeNewPlaylistItemResultErrors(playlistItemResult));
        }
    }

    private String summarizeNewPlaylistItemResultErrors(NewPlaylistItemResult playlistItemResult) throws Exception {
        try {
            Status status;
            if (playlistItemResult.getStatus() != null && (status = playlistItemResult.getStatus()).getCode() != 0) {
                throw new IOException(String.format("PlaylistItem could not be created. Code: %d Message: %s", status.getCode(), status.getMessage()));
            }
        }
        catch (IOException e) {
            if (StringUtils.contains((CharSequence)e.getMessage(), (CharSequence)"permanent failure")) {
                throw new CopyException("Permanent Failure:", (Throwable)e);
            }
            if (StringUtils.contains((CharSequence)e.getMessage(), (CharSequence)"Fail to find track matching") || StringUtils.contains((CharSequence)e.getMessage(), (CharSequence)"Missing ISRC in playlist item") || StringUtils.contains((CharSequence)e.getMessage(), (CharSequence)"Max videos exceeded")) {
                this.monitor.info(() -> "Skippable Failure:", new Object[]{e});
            }
            throw e;
        }
        return "";
    }

    @Nullable
    private GoogleArtist[] getArtists(List<MusicGroup> artists) {
        if (artists == null || artists.isEmpty()) {
            return null;
        }
        GoogleArtist[] googleArtists = new GoogleArtist[artists.size()];
        for (int i = 0; i < artists.size(); ++i) {
            GoogleArtist googleArtist = new GoogleArtist();
            googleArtist.setTitle(artists.get(i).getName());
            googleArtists[i] = googleArtist;
        }
        return googleArtists;
    }

    private ImportPlaylistItemRequest buildImportPlaylistItemRequest(MusicPlaylistItem playlistItem, String playlistId) {
        GooglePlaylistItem googlePlaylistItem = new GooglePlaylistItem();
        GoogleTrack googleTrack = new GoogleTrack();
        GoogleRelease googleRelease = new GoogleRelease();
        googleRelease.setIcpn(playlistItem.getTrack().getMusicRelease().getIcpnCode());
        googleRelease.setReleaseTitle(playlistItem.getTrack().getMusicRelease().getTitle());
        googleTrack.setIsrc(playlistItem.getTrack().getIsrcCode());
        googleTrack.setTitle(playlistItem.getTrack().getTitle());
        googleTrack.setArtistReferences(this.getArtists(playlistItem.getTrack().getByArtists()));
        googleTrack.setDuration(Durations.toString((Duration)Durations.fromMillis((long)playlistItem.getTrack().getDurationMillis())));
        if (playlistItem.getTrack().getIsExplicit()) {
            googleTrack.setExplicitType("EXPLICIT_TYPE_EXPLICIT");
        } else {
            googleTrack.setExplicitType("EXPLICIT_TYPE_NOT_EXPLICIT");
        }
        googleTrack.setReleaseReference(googleRelease);
        googlePlaylistItem.setTrack(googleTrack);
        googlePlaylistItem.setOrder(playlistItem.getOrder());
        return new ImportPlaylistItemRequest(playlistId, googlePlaylistItem);
    }

    private synchronized GoogleMusicHttpApi getOrCreateMusicInterface(UUID jobId, TokensAndUrlAuthData authData) {
        if (this.musicHttpApi != null) {
            return this.musicHttpApi;
        }
        if (this.musicHttpApisMap.containsKey(jobId)) {
            return this.musicHttpApisMap.get(jobId);
        }
        GoogleMusicHttpApi newMusicHttpApi = this.makeMusicHttpApi(authData);
        this.musicHttpApisMap.put(jobId, newMusicHttpApi);
        return newMusicHttpApi;
    }

    private synchronized GoogleMusicHttpApi makeMusicHttpApi(TokensAndUrlAuthData authData) {
        Credential credential = this.credentialFactory.createCredential(authData);
        return new GoogleMusicHttpApi(credential, this.jsonFactory, this.monitor, this.credentialFactory, this.writesPerSecond);
    }
}

