/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.google.contacts;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.services.people.v1.PeopleService;
import com.google.api.services.people.v1.model.EmailAddress;
import com.google.api.services.people.v1.model.FieldMetadata;
import com.google.api.services.people.v1.model.Name;
import com.google.api.services.people.v1.model.Person;
import com.google.api.services.people.v1.model.PhoneNumber;
import com.google.api.services.people.v1.model.Source;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import ezvcard.VCard;
import ezvcard.io.json.JCardReader;
import ezvcard.property.Address;
import ezvcard.property.Email;
import ezvcard.property.StructuredName;
import ezvcard.property.Telephone;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.datatransferproject.datatransfer.google.common.GoogleCredentialFactory;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.provider.ImportResult;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.types.common.models.contacts.ContactsModelWrapper;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class GoogleContactsImporter
implements Importer<TokensAndUrlAuthData, ContactsModelWrapper> {
    private static final FieldMetadata PRIMARY_FIELD_METADATA = new FieldMetadata().setPrimary(Boolean.valueOf(true));
    private static final FieldMetadata SECONDARY_FIELD_METADATA = new FieldMetadata().setPrimary(Boolean.valueOf(false));
    private final GoogleCredentialFactory credentialFactory;
    private volatile PeopleService peopleService;

    public GoogleContactsImporter(GoogleCredentialFactory credentialFactory) {
        this.credentialFactory = credentialFactory;
        this.peopleService = null;
    }

    @VisibleForTesting
    GoogleContactsImporter(PeopleService peopleService) {
        this.credentialFactory = null;
        this.peopleService = peopleService;
    }

    @VisibleForTesting
    static Person convert(VCard vCard) {
        Person person = new Person();
        Preconditions.checkArgument((boolean)GoogleContactsImporter.atLeastOneNamePresent(vCard), (Object)"At least one name must be present");
        person.setNames(Collections.singletonList(GoogleContactsImporter.getPrimaryGoogleName(vCard.getStructuredNames())));
        if (vCard.getAddresses() != null) {
            person.setAddresses(vCard.getAddresses().stream().map(GoogleContactsImporter::convertToGoogleAddress).collect(Collectors.toList()));
        }
        if (vCard.getTelephoneNumbers() != null) {
            person.setPhoneNumbers(vCard.getTelephoneNumbers().stream().map(GoogleContactsImporter::convertToGooglePhoneNumber).collect(Collectors.toList()));
        }
        if (vCard.getEmails() != null) {
            person.setEmailAddresses(vCard.getEmails().stream().map(GoogleContactsImporter::convertToGoogleEmail).collect(Collectors.toList()));
        }
        return person;
    }

    private static Name convertToGoogleName(StructuredName vCardName) {
        Name name = new Name();
        name.setFamilyName(vCardName.getFamily());
        name.setGivenName(vCardName.getGiven());
        FieldMetadata fieldMetadata = new FieldMetadata();
        boolean isPrimary = vCardName.getAltId() == null;
        fieldMetadata.setPrimary(Boolean.valueOf(isPrimary));
        String vCardNameSource = vCardName.getParameter("Source_type");
        if ("CONTACT".equals(vCardNameSource)) {
            Source source = new Source().setType(vCardNameSource);
            fieldMetadata.setSource(source);
        }
        name.setMetadata(fieldMetadata);
        return name;
    }

    private static Name getPrimaryGoogleName(List<StructuredName> vCardNameList) {
        List primaryNames = vCardNameList.stream().filter(a -> a.getAltId() == null).collect(Collectors.toList());
        StructuredName primaryVCardName = primaryNames.size() > 0 ? (StructuredName)primaryNames.get(0) : vCardNameList.get(0);
        return GoogleContactsImporter.convertToGoogleName(primaryVCardName);
    }

    private static com.google.api.services.people.v1.model.Address convertToGoogleAddress(Address vCardAddress) {
        com.google.api.services.people.v1.model.Address personAddress = new com.google.api.services.people.v1.model.Address();
        personAddress.setCountry(vCardAddress.getCountry());
        personAddress.setRegion(vCardAddress.getRegion());
        personAddress.setCity(vCardAddress.getLocality());
        personAddress.setPostalCode(vCardAddress.getPostalCode());
        personAddress.setStreetAddress(vCardAddress.getStreetAddress());
        personAddress.setPoBox(vCardAddress.getPoBox());
        personAddress.setExtendedAddress(vCardAddress.getExtendedAddress());
        personAddress.setMetadata(vCardAddress.getPref() != null && vCardAddress.getPref() == 1 ? PRIMARY_FIELD_METADATA : SECONDARY_FIELD_METADATA);
        return personAddress;
    }

    private static PhoneNumber convertToGooglePhoneNumber(Telephone vCardTelephone) {
        PhoneNumber phoneNumber = new PhoneNumber();
        phoneNumber.setValue(vCardTelephone.getText());
        if (vCardTelephone.getPref() != null && vCardTelephone.getPref() == 1) {
            phoneNumber.setMetadata(PRIMARY_FIELD_METADATA);
        } else {
            phoneNumber.setMetadata(SECONDARY_FIELD_METADATA);
        }
        return phoneNumber;
    }

    private static EmailAddress convertToGoogleEmail(Email vCardEmail) {
        EmailAddress emailAddress = new EmailAddress();
        emailAddress.setValue((String)vCardEmail.getValue());
        if (vCardEmail.getPref() != null && vCardEmail.getPref() == 1) {
            emailAddress.setMetadata(PRIMARY_FIELD_METADATA);
        } else {
            emailAddress.setMetadata(SECONDARY_FIELD_METADATA);
        }
        return emailAddress;
    }

    private static boolean atLeastOneNamePresent(VCard vCard) {
        return vCard.getStructuredNames().size() >= 1 && vCard.getStructuredName() != null;
    }

    public ImportResult importItem(UUID jobId, IdempotentImportExecutor idempotentExecutor, TokensAndUrlAuthData authData, ContactsModelWrapper data) throws Exception {
        JCardReader reader = new JCardReader(data.getVCards());
        try {
            List vCardList = reader.readAll();
            PeopleService.People peopleService = this.getOrCreatePeopleService(authData).people();
            for (VCard vCard : vCardList) {
                Person person = GoogleContactsImporter.convert(vCard);
                idempotentExecutor.executeAndSwallowIOExceptions(vCard.toString(), vCard.getFormattedName().toString(), () -> ((Person)peopleService.createContact(person).execute()).toPrettyString());
            }
            return ImportResult.OK;
        }
        catch (IOException e) {
            return new ImportResult((Throwable)e);
        }
    }

    private PeopleService getOrCreatePeopleService(TokensAndUrlAuthData authData) {
        return this.peopleService == null ? this.makePeopleService(authData) : this.peopleService;
    }

    private synchronized PeopleService makePeopleService(TokensAndUrlAuthData authData) {
        Credential credential = this.credentialFactory.createCredential(authData);
        return new PeopleService.Builder(this.credentialFactory.getHttpTransport(), this.credentialFactory.getJsonFactory(), (HttpRequestInitializer)credential).setApplicationName("Portability").build();
    }
}

