/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.google.music;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.json.JsonFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.text.ParseException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.datatransfer.google.common.GoogleCredentialFactory;
import org.datatransferproject.datatransfer.google.music.GoogleMusicHttpApi;
import org.datatransferproject.datatransfer.google.musicModels.ExportReleaseResponse;
import org.datatransferproject.datatransfer.google.musicModels.GoogleArtist;
import org.datatransferproject.datatransfer.google.musicModels.GooglePlaylist;
import org.datatransferproject.datatransfer.google.musicModels.GooglePlaylistItem;
import org.datatransferproject.datatransfer.google.musicModels.GoogleRelease;
import org.datatransferproject.datatransfer.google.musicModels.GoogleTrack;
import org.datatransferproject.datatransfer.google.musicModels.PlaylistExportResponse;
import org.datatransferproject.datatransfer.google.musicModels.PlaylistItemExportResponse;
import org.datatransferproject.spi.transfer.provider.ExportResult;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.types.ContinuationData;
import org.datatransferproject.spi.transfer.types.InvalidTokenException;
import org.datatransferproject.spi.transfer.types.PermissionDeniedException;
import org.datatransferproject.types.common.ExportInformation;
import org.datatransferproject.types.common.PaginationData;
import org.datatransferproject.types.common.StringPaginationToken;
import org.datatransferproject.types.common.models.ContainerResource;
import org.datatransferproject.types.common.models.DataModel;
import org.datatransferproject.types.common.models.IdOnlyContainerResource;
import org.datatransferproject.types.common.models.music.MusicContainerResource;
import org.datatransferproject.types.common.models.music.MusicGroup;
import org.datatransferproject.types.common.models.music.MusicPlaylist;
import org.datatransferproject.types.common.models.music.MusicPlaylistItem;
import org.datatransferproject.types.common.models.music.MusicRecording;
import org.datatransferproject.types.common.models.music.MusicRelease;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class GoogleMusicExporter
implements Exporter<TokensAndUrlAuthData, MusicContainerResource> {
    static final String PLAYLIST_TRACK_RELEASE_TOKEN_PREFIX = "playlist:track:release:";
    static final String PLAYLIST_TRACK_TOKEN_PREFIX = "playlist:track:";
    static final String PLAYLIST_RELEASE_TOKEN_PREFIX = "playlist:release:";
    static final String TRACK_RELEASE_TOKEN_PREFIX = "track:release:";
    static final String PLAYLIST_TOKEN_PREFIX = "playlist:";
    static final String TRACK_TOKEN_PREFIX = "track:";
    static final String RELEASE_TOKEN_PREFIX = "release:";
    static final String GOOGLE_PLAYLIST_NAME_PREFIX = "playlists/";
    private final GoogleCredentialFactory credentialFactory;
    private final JsonFactory jsonFactory;
    private volatile GoogleMusicHttpApi musicHttpApi;
    private final Monitor monitor;

    public GoogleMusicExporter(GoogleCredentialFactory credentialFactory, JsonFactory jsonFactory, Monitor monitor) {
        this.credentialFactory = credentialFactory;
        this.jsonFactory = jsonFactory;
        this.monitor = monitor;
    }

    @VisibleForTesting
    GoogleMusicExporter(GoogleCredentialFactory credentialFactory, JsonFactory jsonFactory, GoogleMusicHttpApi musicHttpApi, Monitor monitor) {
        this.credentialFactory = credentialFactory;
        this.jsonFactory = jsonFactory;
        this.musicHttpApi = musicHttpApi;
        this.monitor = monitor;
    }

    public ExportResult<MusicContainerResource> export(UUID jobId, TokensAndUrlAuthData authData, Optional<ExportInformation> exportInformation) throws IOException, InvalidTokenException, PermissionDeniedException, ParseException {
        boolean paginationDataPresent;
        if (!exportInformation.isPresent()) {
            StringPaginationToken paginationToken = new StringPaginationToken(PLAYLIST_TOKEN_PREFIX);
            return this.exportPlaylists(authData, Optional.of(paginationToken), jobId);
        }
        if (exportInformation.get().getContainerResource() instanceof IdOnlyContainerResource) {
            return this.exportPlaylistItems(authData, (IdOnlyContainerResource)exportInformation.get().getContainerResource(), Optional.ofNullable(exportInformation.get().getPaginationData()), jobId);
        }
        StringPaginationToken paginationToken = (StringPaginationToken)exportInformation.get().getPaginationData();
        boolean bl = paginationDataPresent = paginationToken != null;
        if (paginationDataPresent && paginationToken.getToken().startsWith(PLAYLIST_TOKEN_PREFIX)) {
            return this.exportPlaylists(authData, Optional.of(paginationToken), jobId);
        }
        if (paginationDataPresent && paginationToken.getToken().startsWith(TRACK_TOKEN_PREFIX)) {
            return new ExportResult(ExportResult.ResultType.END, null, null);
        }
        if (paginationDataPresent && paginationToken.getToken().startsWith(RELEASE_TOKEN_PREFIX)) {
            return this.exportReleases(authData, Optional.of(paginationToken), jobId);
        }
        return new ExportResult(ExportResult.ResultType.END, null, null);
    }

    @VisibleForTesting
    ExportResult<MusicContainerResource> exportPlaylists(TokensAndUrlAuthData authData, Optional<PaginationData> paginationData, UUID jobId) throws IOException, InvalidTokenException, PermissionDeniedException {
        StringPaginationToken nextPageData;
        Optional<String> paginationToken = Optional.empty();
        String pageTokenPrefix = "";
        if (paginationData.isPresent()) {
            String token = ((StringPaginationToken)paginationData.get()).getToken();
            Preconditions.checkArgument((boolean)token.startsWith(PLAYLIST_TOKEN_PREFIX), (String)"Invalid pagination token %s", (Object)token);
            pageTokenPrefix = token.substring(0, this.getTokenPrefixLength(token));
            if (this.getTokenPrefixLength(token) < token.length()) {
                paginationToken = Optional.of(token.substring(this.getTokenPrefixLength(token)));
            }
        }
        PlaylistExportResponse playlistExportResponse = this.getOrCreateMusicHttpApi(authData).exportPlaylists(paginationToken);
        String token = playlistExportResponse.getNextPageToken();
        ArrayList<MusicPlaylist> playlists = new ArrayList<MusicPlaylist>();
        GooglePlaylist[] googlePlaylists = playlistExportResponse.getPlaylists();
        ExportResult.ResultType resultType = ExportResult.ResultType.END;
        if (Strings.isNullOrEmpty((String)token)) {
            nextPageData = new StringPaginationToken(pageTokenPrefix.substring(PLAYLIST_TOKEN_PREFIX.length()));
        } else {
            nextPageData = new StringPaginationToken(pageTokenPrefix + token);
            resultType = ExportResult.ResultType.CONTINUE;
        }
        ContinuationData continuationData = new ContinuationData((PaginationData)nextPageData);
        if (googlePlaylists != null && googlePlaylists.length > 0) {
            for (GooglePlaylist googlePlaylist : googlePlaylists) {
                Instant createTime = googlePlaylist.getCreateTime() == null ? null : Instant.parse(googlePlaylist.getCreateTime());
                Instant updateTime = googlePlaylist.getUpdateTime() == null ? null : Instant.parse(googlePlaylist.getUpdateTime());
                MusicPlaylist musicPlaylist = new MusicPlaylist(googlePlaylist.getName().substring(GOOGLE_PLAYLIST_NAME_PREFIX.length()), googlePlaylist.getTitle(), googlePlaylist.getDescription(), createTime, updateTime);
                playlists.add(musicPlaylist);
                this.monitor.debug(() -> String.format("%s: Google Music exporting playlist: %s", jobId, musicPlaylist.getId()), new Object[0]);
                continuationData.addContainerResource((ContainerResource)new IdOnlyContainerResource(musicPlaylist.getId()));
            }
        }
        MusicContainerResource containerResource = new MusicContainerResource(playlists, null, null, null);
        return new ExportResult(resultType, (DataModel)containerResource, continuationData);
    }

    @VisibleForTesting
    ExportResult<MusicContainerResource> exportPlaylistItems(TokensAndUrlAuthData authData, IdOnlyContainerResource playlistData, Optional<PaginationData> paginationData, UUID jobId) throws IOException, InvalidTokenException, PermissionDeniedException, ParseException {
        String playlistId = playlistData.getId();
        Optional<String> paginationToken = paginationData.map(value -> ((StringPaginationToken)value).getToken());
        PlaylistItemExportResponse playlistItemExportResponse = this.getOrCreateMusicHttpApi(authData).exportPlaylistItems(playlistId, paginationToken);
        StringPaginationToken nextPageData = null;
        if (!Strings.isNullOrEmpty((String)playlistItemExportResponse.getNextPageToken())) {
            nextPageData = new StringPaginationToken(playlistItemExportResponse.getNextPageToken());
        }
        ContinuationData continuationData = new ContinuationData(nextPageData);
        MusicContainerResource containerResource = null;
        GooglePlaylistItem[] googlePlaylistItems = playlistItemExportResponse.getPlaylistItems();
        ArrayList<MusicPlaylistItem> playlistItems = new ArrayList<MusicPlaylistItem>();
        if (googlePlaylistItems != null && googlePlaylistItems.length > 0) {
            for (GooglePlaylistItem googlePlaylistItem : googlePlaylistItems) {
                playlistItems.add(this.convertPlaylistItem(playlistId, googlePlaylistItem));
                this.monitor.debug(() -> String.format("%s: Google Music exporting playlist item in %s : [track title: %s, track isrc: %s]", jobId, playlistId, googlePlaylistItem.getTrack().getTitle(), googlePlaylistItem.getTrack().getIsrc()), new Object[0]);
            }
            containerResource = new MusicContainerResource(null, playlistItems, null, null);
        }
        return new ExportResult(ExportResult.ResultType.CONTINUE, containerResource, continuationData);
    }

    @VisibleForTesting
    ExportResult<MusicContainerResource> exportReleases(TokensAndUrlAuthData authData, Optional<PaginationData> paginationData, UUID jobId) throws InvalidTokenException, PermissionDeniedException, IOException {
        Optional<String> paginationToken = this.getToken(RELEASE_TOKEN_PREFIX, paginationData);
        ExportReleaseResponse exportReleaseResponse = this.getOrCreateMusicHttpApi(authData).exportReleases(paginationToken);
        StringPaginationToken nextPageData = null;
        String token = exportReleaseResponse.getNextPageToken();
        ExportResult.ResultType resultType = ExportResult.ResultType.END;
        if (!Strings.isNullOrEmpty((String)token)) {
            nextPageData = new StringPaginationToken(RELEASE_TOKEN_PREFIX + token);
            resultType = ExportResult.ResultType.CONTINUE;
        }
        ContinuationData continuationData = new ContinuationData(nextPageData);
        MusicContainerResource containerResource = null;
        GoogleRelease[] googleReleases = exportReleaseResponse.getReleases();
        ArrayList<MusicRelease> exportableReleases = new ArrayList<MusicRelease>();
        if (googleReleases != null && googleReleases.length > 0) {
            for (GoogleRelease googleRelease : googleReleases) {
                exportableReleases.add(this.convertRelease(googleRelease));
                this.monitor.debug(() -> String.format("%s: Google Music exporting release item: [release title: %s, release icpn: %s]", jobId, googleRelease.getTitle(), googleRelease.getIcpn()), new Object[0]);
            }
            containerResource = new MusicContainerResource(null, null, null, exportableReleases);
        }
        return new ExportResult(resultType, containerResource, continuationData);
    }

    private Optional<String> getToken(String prefix, Optional<PaginationData> paginationData) {
        Optional<String> paginationToken = Optional.empty();
        if (paginationData.isPresent()) {
            String token = ((StringPaginationToken)paginationData.get()).getToken();
            Preconditions.checkArgument((boolean)token.startsWith(prefix), (String)"Invalid pagination token %s", (Object)token);
            if (prefix.length() < token.length()) {
                paginationToken = Optional.of(token.substring(prefix.length()));
            }
        }
        return paginationToken;
    }

    private int getTokenPrefixLength(String token) {
        ImmutableList knownPrefixes = ImmutableList.of((Object)PLAYLIST_TRACK_RELEASE_TOKEN_PREFIX, (Object)PLAYLIST_TRACK_TOKEN_PREFIX, (Object)PLAYLIST_RELEASE_TOKEN_PREFIX, (Object)PLAYLIST_TOKEN_PREFIX, (Object)TRACK_RELEASE_TOKEN_PREFIX, (Object)TRACK_TOKEN_PREFIX, (Object)RELEASE_TOKEN_PREFIX);
        for (String prefix : knownPrefixes) {
            if (!token.startsWith(prefix)) continue;
            return prefix.length();
        }
        return 0;
    }

    @Nullable
    private List<MusicGroup> createMusicGroups(GoogleArtist[] artists) {
        if (artists == null) {
            return null;
        }
        ArrayList<MusicGroup> musicGroups = new ArrayList<MusicGroup>();
        for (GoogleArtist artist : artists) {
            musicGroups.add(new MusicGroup(artist.getTitle()));
        }
        return musicGroups;
    }

    private MusicRelease convertRelease(GoogleRelease googleRelease) {
        return new MusicRelease(googleRelease.getIcpn(), googleRelease.getTitle(), null);
    }

    private MusicPlaylistItem convertPlaylistItem(String playlistId, GooglePlaylistItem googlePlaylistItem) throws ParseException {
        GoogleTrack track = googlePlaylistItem.getTrack();
        GoogleRelease release = track.getReleaseReference();
        return new MusicPlaylistItem(new MusicRecording(track.getIsrc(), track.getTitle(), track.convertDurationToMillions(), new MusicRelease(release.getIcpn(), release.getTitle(), null), this.createMusicGroups(track.getArtistReferences()), "EXPLICIT_TYPE_EXPLICIT".equals(track.getExplicitType())), playlistId, googlePlaylistItem.getOrder());
    }

    private synchronized GoogleMusicHttpApi getOrCreateMusicHttpApi(TokensAndUrlAuthData authData) {
        return this.musicHttpApi == null ? this.makeMusicHttpApi(authData) : this.musicHttpApi;
    }

    private synchronized GoogleMusicHttpApi makeMusicHttpApi(TokensAndUrlAuthData authData) {
        Credential credential = this.credentialFactory.createCredential(authData);
        return new GoogleMusicHttpApi(credential, this.jsonFactory, this.monitor, this.credentialFactory, 1.0);
    }
}

