/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.google.videos;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.json.JsonFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.datatransfer.google.common.GoogleCredentialFactory;
import org.datatransferproject.datatransfer.google.common.GoogleErrorLogger;
import org.datatransferproject.datatransfer.google.mediaModels.GoogleMediaItem;
import org.datatransferproject.datatransfer.google.mediaModels.MediaItemSearchResponse;
import org.datatransferproject.datatransfer.google.videos.GoogleVideosInterface;
import org.datatransferproject.spi.cloud.storage.JobStore;
import org.datatransferproject.spi.transfer.provider.ExportResult;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.types.ContinuationData;
import org.datatransferproject.types.common.ExportInformation;
import org.datatransferproject.types.common.StringPaginationToken;
import org.datatransferproject.types.common.models.videos.VideoModel;
import org.datatransferproject.types.common.models.videos.VideosContainerResource;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;
import org.datatransferproject.types.transfer.errors.ErrorDetail;

public class GoogleVideosExporter
implements Exporter<TokensAndUrlAuthData, VideosContainerResource> {
    private final GoogleCredentialFactory credentialFactory;
    private volatile GoogleVideosInterface videosInterface;
    private final JobStore jobStore;
    private JsonFactory jsonFactory;
    private final Monitor monitor;

    public GoogleVideosExporter(GoogleCredentialFactory credentialFactory, JobStore jobStore, JsonFactory jsonFactory, Monitor monitor) {
        this.credentialFactory = credentialFactory;
        this.jobStore = jobStore;
        this.jsonFactory = jsonFactory;
        this.monitor = monitor;
    }

    @VisibleForTesting
    GoogleVideosExporter(GoogleCredentialFactory credentialFactory, JobStore jobStore, GoogleVideosInterface videosInterface, Monitor monitor) {
        this.credentialFactory = credentialFactory;
        this.jobStore = jobStore;
        this.videosInterface = videosInterface;
        this.monitor = monitor;
    }

    public ExportResult<VideosContainerResource> export(UUID jobId, TokensAndUrlAuthData authData, Optional<ExportInformation> exportInformation) throws IOException {
        return this.exportVideos(authData, exportInformation.map(e -> (StringPaginationToken)e.getPaginationData()), jobId);
    }

    @VisibleForTesting
    ExportResult<VideosContainerResource> exportVideos(TokensAndUrlAuthData authData, Optional<StringPaginationToken> paginationData, UUID jobId) throws IOException {
        Optional<String> paginationToken = paginationData.map(StringPaginationToken::getToken);
        MediaItemSearchResponse mediaItemSearchResponse = this.getOrCreateVideosInterface(authData).listVideoItems(paginationToken);
        StringPaginationToken nextPageData = null;
        if (!Strings.isNullOrEmpty((String)mediaItemSearchResponse.getNextPageToken())) {
            nextPageData = new StringPaginationToken(mediaItemSearchResponse.getNextPageToken());
        }
        ContinuationData continuationData = new ContinuationData(nextPageData);
        VideosContainerResource containerResource = null;
        GoogleMediaItem[] mediaItems = mediaItemSearchResponse.getMediaItems();
        if (mediaItems != null && mediaItems.length > 0) {
            List<VideoModel> videos = this.convertVideosList(mediaItems, jobId);
            containerResource = new VideosContainerResource(null, videos);
        }
        ExportResult.ResultType resultType = ExportResult.ResultType.CONTINUE;
        if (nextPageData == null) {
            resultType = ExportResult.ResultType.END;
        }
        return new ExportResult(resultType, containerResource, continuationData);
    }

    private List<VideoModel> convertVideosList(GoogleMediaItem[] mediaItems, UUID jobId) throws IOException {
        ArrayList<VideoModel> videos = new ArrayList<VideoModel>(mediaItems.length);
        ImmutableList.Builder errors = ImmutableList.builder();
        for (GoogleMediaItem mediaItem : mediaItems) {
            if (mediaItem.getMediaMetadata().getVideo() == null) continue;
            try {
                videos.add(GoogleMediaItem.convertToVideoModel(Optional.empty(), mediaItem));
            }
            catch (ParseException e) {
                this.monitor.info(() -> String.format("%s: MediaItem (id: %s) failed to be converted to PhotoModel, and is being skipped: %s", jobId, mediaItem.getId(), e), new Object[0]);
                errors.add((Object)GoogleErrorLogger.createErrorDetail(mediaItem.getId(), mediaItem.getFilename(), e, true));
            }
        }
        GoogleErrorLogger.logFailedItemErrors(this.jobStore, jobId, (ImmutableList<ErrorDetail>)errors.build());
        return videos;
    }

    private synchronized GoogleVideosInterface getOrCreateVideosInterface(TokensAndUrlAuthData authData) {
        return this.videosInterface == null ? this.makeVideosInterface(authData) : this.videosInterface;
    }

    private synchronized GoogleVideosInterface makeVideosInterface(TokensAndUrlAuthData authData) {
        Credential credential = this.credentialFactory.createCredential(authData);
        return new GoogleVideosInterface(credential, this.jsonFactory);
    }
}

