/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.google.music;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.ArrayMap;
import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import com.google.common.util.concurrent.RateLimiter;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.datatransfer.google.common.GoogleCredentialFactory;
import org.datatransferproject.datatransfer.google.musicModels.BatchPlaylistItemRequest;
import org.datatransferproject.datatransfer.google.musicModels.BatchPlaylistItemResponse;
import org.datatransferproject.datatransfer.google.musicModels.ExportReleaseResponse;
import org.datatransferproject.datatransfer.google.musicModels.GooglePlaylist;
import org.datatransferproject.datatransfer.google.musicModels.GoogleRelease;
import org.datatransferproject.datatransfer.google.musicModels.ImportPlaylistRequest;
import org.datatransferproject.datatransfer.google.musicModels.PlaylistExportResponse;
import org.datatransferproject.datatransfer.google.musicModels.PlaylistItemExportResponse;
import org.datatransferproject.spi.transfer.types.InvalidTokenException;
import org.datatransferproject.spi.transfer.types.PermissionDeniedException;

public class GoogleMusicHttpApi {
    private static final String BASE_URL = "https://youtubemediaconnect.googleapis.com/v1/users/me/musicLibrary/";
    private static final String RELEASE_BASE_URL = "https://youtubemediaconnect.googleapis.com/v1/releases";
    private static final int PLAYLIST_PAGE_SIZE = 20;
    private static final int PLAYLIST_ITEM_PAGE_SIZE = 50;
    private static final String PLAYLIST_ID_KEY = "playlistId";
    private static final String PAGE_SIZE_KEY = "pageSize";
    private static final String TOKEN_KEY = "pageToken";
    private static final String ORIGINAL_PLAYLIST_ID_KEY = "originalPlaylistId";
    private static final String ACCESS_TOKEN_KEY = "access_token";
    private static final int RELEASE_ITEM_PAGE_SIZE = 50;
    private final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final HttpTransport httpTransport = new NetHttpTransport();
    private Credential credential;
    private final JsonFactory jsonFactory;
    private final Monitor monitor;
    private final GoogleCredentialFactory credentialFactory;
    private final RateLimiter writeRateLimiter;

    GoogleMusicHttpApi(Credential credential, JsonFactory jsonFactory, Monitor monitor, GoogleCredentialFactory credentialFactory, double writesPerSecond) {
        this.credential = credential;
        this.jsonFactory = jsonFactory;
        this.monitor = monitor;
        this.credentialFactory = credentialFactory;
        this.writeRateLimiter = RateLimiter.create((double)writesPerSecond);
    }

    PlaylistExportResponse exportPlaylists(Optional<String> pageToken) throws IOException, InvalidTokenException, PermissionDeniedException {
        LinkedHashMap<String, String> exportPlyalistsRequestMap = new LinkedHashMap<String, String>();
        LinkedHashMap params = new LinkedHashMap();
        exportPlyalistsRequestMap.put(PAGE_SIZE_KEY, String.valueOf(20));
        if (pageToken.isPresent()) {
            exportPlyalistsRequestMap.put(TOKEN_KEY, pageToken.get());
        }
        JsonHttpContent content = new JsonHttpContent(this.jsonFactory, this.createJsonMap(exportPlyalistsRequestMap));
        return this.makePostRequest("https://youtubemediaconnect.googleapis.com/v1/users/me/musicLibrary/playlists:export", Optional.of(params), (HttpContent)content, PlaylistExportResponse.class);
    }

    PlaylistItemExportResponse exportPlaylistItems(String playlistId, Optional<String> pageToken) throws IOException, InvalidTokenException, PermissionDeniedException {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put(PLAYLIST_ID_KEY, playlistId);
        params.put(PAGE_SIZE_KEY, String.valueOf(50));
        if (pageToken.isPresent()) {
            params.put(TOKEN_KEY, pageToken.get());
        }
        return this.makeGetRequest("https://youtubemediaconnect.googleapis.com/v1/users/me/musicLibrary/playlists:exportPlaylistItems", Optional.of(params), PlaylistItemExportResponse.class);
    }

    ExportReleaseResponse exportReleases(Optional<String> pageToken) throws InvalidTokenException, PermissionDeniedException, IOException {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put(PAGE_SIZE_KEY, String.valueOf(50));
        if (pageToken.isPresent()) {
            params.put(TOKEN_KEY, pageToken.get());
        }
        return this.makeGetRequest(RELEASE_BASE_URL, Optional.of(params), ExportReleaseResponse.class);
    }

    GooglePlaylist importPlaylist(GooglePlaylist playlist, String playlistId) throws IOException, InvalidTokenException, PermissionDeniedException {
        ImportPlaylistRequest importPlaylistRequest = new ImportPlaylistRequest(playlist, playlistId);
        HashMap<String, Object> importPlaylistMap = this.createJsonMap(importPlaylistRequest);
        LinkedHashMap params = new LinkedHashMap();
        JsonHttpContent content = new JsonHttpContent(this.jsonFactory, importPlaylistMap);
        return this.makePostRequest("https://youtubemediaconnect.googleapis.com/v1/users/me/musicLibrary/playlists/" + playlistId + ":import", Optional.of(params), (HttpContent)content, GooglePlaylist.class);
    }

    BatchPlaylistItemResponse importPlaylistItems(BatchPlaylistItemRequest playlistItemRequest) throws IOException, InvalidTokenException, PermissionDeniedException {
        HashMap<String, Object> playlistItemMap = this.createJsonMap(playlistItemRequest);
        JsonHttpContent content = new JsonHttpContent(this.jsonFactory, playlistItemMap);
        return this.makePostRequest("https://youtubemediaconnect.googleapis.com/v1/users/me/musicLibrary/playlists:importPlaylistItems", Optional.empty(), (HttpContent)content, BatchPlaylistItemResponse.class);
    }

    GoogleRelease createRelease(GoogleRelease googleRelease) throws IOException, InvalidTokenException, PermissionDeniedException {
        HashMap<String, Object> googleReleaseMap = this.createJsonMap(googleRelease);
        LinkedHashMap params = new LinkedHashMap();
        JsonHttpContent content = new JsonHttpContent(this.jsonFactory, googleReleaseMap);
        return this.makePostRequest(RELEASE_BASE_URL, Optional.of(params), (HttpContent)content, GoogleRelease.class);
    }

    private <T> T makeGetRequest(String baseUrl, Optional<Map<String, String>> parameters, Class<T> clazz) throws IOException, InvalidTokenException, PermissionDeniedException {
        HttpResponse response;
        HttpRequestFactory requestFactory = this.httpTransport.createRequestFactory();
        HttpRequest getRequest = requestFactory.buildGetRequest(new GenericUrl(baseUrl + "?" + this.generateParamsString(parameters)));
        try {
            response = getRequest.execute();
        }
        catch (HttpResponseException e) {
            response = this.handleHttpResponseException(() -> requestFactory.buildGetRequest(new GenericUrl(baseUrl + "?" + this.generateParamsString(parameters))), e);
        }
        Preconditions.checkState((response.getStatusCode() == 200 ? 1 : 0) != 0);
        String result = CharStreams.toString((Readable)new InputStreamReader(response.getContent(), StandardCharsets.UTF_8));
        Gson gson = new Gson();
        return (T)gson.fromJson(result, clazz);
    }

    private <T> T makePostRequest(String baseUrl, Optional<Map<String, String>> parameters, HttpContent httpContent, Class<T> clazz) throws IOException, InvalidTokenException, PermissionDeniedException {
        HttpResponse response;
        this.writeRateLimiter.acquire();
        HttpRequestFactory requestFactory = this.httpTransport.createRequestFactory();
        HttpRequest postRequest = requestFactory.buildPostRequest(new GenericUrl(baseUrl + "?" + this.generateParamsString(parameters)), httpContent);
        postRequest.setReadTimeout(30000);
        try {
            response = postRequest.execute();
        }
        catch (HttpResponseException e) {
            response = this.handleHttpResponseException(() -> requestFactory.buildPostRequest(new GenericUrl(baseUrl + "?" + this.generateParamsString(parameters)), httpContent), e);
        }
        Preconditions.checkState((response.getStatusCode() == 200 ? 1 : 0) != 0);
        String result = CharStreams.toString((Readable)new InputStreamReader(response.getContent(), StandardCharsets.UTF_8));
        if (clazz.isAssignableFrom(String.class)) {
            return (T)result;
        }
        return (T)this.objectMapper.readValue(result, clazz);
    }

    private <T> T makePatchRequest(String baseUrl, Optional<Map<String, String>> parameters, HttpContent httpContent, Class<T> clazz) throws IOException, InvalidTokenException, PermissionDeniedException {
        HttpResponse response;
        this.writeRateLimiter.acquire();
        HttpRequestFactory requestFactory = this.httpTransport.createRequestFactory((HttpRequestInitializer)this.credential);
        HttpRequest patchRequest = GoogleMusicHttpApi.buildPatchRequest(requestFactory, baseUrl, this.generateParamsString(parameters), httpContent);
        try {
            response = patchRequest.execute();
        }
        catch (HttpResponseException e) {
            response = this.handleHttpResponseException(() -> GoogleMusicHttpApi.buildPatchRequest(requestFactory, baseUrl, this.generateParamsString(parameters), httpContent), e);
        }
        Preconditions.checkState((response.getStatusCode() == 200 ? 1 : 0) != 0);
        String result = CharStreams.toString((Readable)new InputStreamReader(response.getContent(), StandardCharsets.UTF_8));
        if (clazz.isAssignableFrom(String.class)) {
            return (T)result;
        }
        return (T)this.objectMapper.readValue(result, clazz);
    }

    private HttpResponse handleHttpResponseException(SupplierWithIO<HttpRequest> httpRequest, HttpResponseException e) throws IOException, InvalidTokenException, PermissionDeniedException {
        int statusCode = e.getStatusCode();
        if (statusCode == 401) {
            this.monitor.info(() -> "Attempting to refresh authorization token", new Object[0]);
            this.credential = this.credentialFactory.refreshCredential(this.credential);
            this.monitor.info(() -> "Refreshed authorization token successfully", new Object[0]);
            return httpRequest.getWithIo().execute();
        }
        if (statusCode == 403) {
            throw new PermissionDeniedException("User permission to youtube music was denied", (Throwable)e);
        }
        throw new IOException("Bad status code: " + e.getStatusCode() + " Error: '" + e.getStatusMessage() + "' Content: " + e.getContent());
    }

    private String generateParamsString(Optional<Map<String, String>> params) {
        ArrayMap updatedParams = new ArrayMap();
        if (params.isPresent()) {
            updatedParams.putAll(params.get());
        }
        updatedParams.put(ACCESS_TOKEN_KEY, (String)Preconditions.checkNotNull((Object)this.credential.getAccessToken()));
        List orderedKeys = updatedParams.keySet().stream().collect(Collectors.toCollection(ArrayList::new));
        Collections.sort(orderedKeys);
        ArrayList<CallSite> paramStrings = new ArrayList<CallSite>();
        for (String key : orderedKeys) {
            String k = key.trim();
            String v = ((String)updatedParams.get(key)).trim();
            paramStrings.add((CallSite)((Object)(k + "=" + v)));
        }
        return String.join((CharSequence)"&", paramStrings);
    }

    private HashMap<String, Object> createJsonMap(Object object) throws IOException {
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        return (HashMap)this.objectMapper.readValue(this.objectMapper.writeValueAsString(object), (TypeReference)typeRef);
    }

    private static HttpRequest buildPatchRequest(HttpRequestFactory requestFactory, String baseUrl, String parametersString, HttpContent httpContent) throws IOException {
        return requestFactory.buildPatchRequest(new GenericUrl(baseUrl + "?" + parametersString), httpContent).setRequestMethod("POST").setHeaders(new HttpHeaders().set("X-HTTP-Method-Override", (Object)"PATCH"));
    }

    private static interface SupplierWithIO<T> {
        public T getWithIo() throws IOException;
    }
}

