/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.koofr.videos;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.atomic.LongAdder;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.spi.cloud.connection.ConnectionProvider;
import org.datatransferproject.spi.cloud.storage.JobStore;
import org.datatransferproject.spi.cloud.storage.TemporaryPerJobDataStore;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.idempotentexecutor.ItemImportResult;
import org.datatransferproject.spi.transfer.provider.ImportResult;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.spi.transfer.types.DestinationMemoryFullException;
import org.datatransferproject.spi.transfer.types.InvalidTokenException;
import org.datatransferproject.transfer.koofr.KoofrTransmogrificationConfig;
import org.datatransferproject.transfer.koofr.common.KoofrClient;
import org.datatransferproject.transfer.koofr.common.KoofrClientFactory;
import org.datatransferproject.types.common.DownloadableItem;
import org.datatransferproject.types.common.ImportableItem;
import org.datatransferproject.types.common.models.videos.VideoAlbum;
import org.datatransferproject.types.common.models.videos.VideoModel;
import org.datatransferproject.types.common.models.videos.VideosContainerResource;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class KoofrVideosImporter
implements Importer<TokensAndUrlAuthData, VideosContainerResource> {
    private static final String SKIPPED_FILE_RESULT_FORMAT = "skipped-%s";
    private final KoofrClientFactory koofrClientFactory;
    private final ConnectionProvider connectionProvider;
    private final Monitor monitor;

    public KoofrVideosImporter(KoofrClientFactory koofrClientFactory, Monitor monitor, JobStore jobStore) {
        this.koofrClientFactory = koofrClientFactory;
        this.connectionProvider = new ConnectionProvider((TemporaryPerJobDataStore)jobStore);
        this.monitor = monitor;
    }

    public ImportResult importItem(UUID jobId, IdempotentImportExecutor idempotentImportExecutor, TokensAndUrlAuthData authData, VideosContainerResource resource) throws Exception {
        KoofrClient koofrClient = this.koofrClientFactory.create(authData);
        this.monitor.debug(() -> String.format("%s: Importing %s albums and %s videos", jobId, resource.getAlbums().size(), resource.getVideos().size()), new Object[0]);
        for (VideoAlbum album : resource.getAlbums()) {
            idempotentImportExecutor.executeAndSwallowIOExceptions(album.getId(), album.getName(), () -> this.createAlbumFolder(album, koofrClient));
        }
        LongAdder totalImportedFilesSizes = new LongAdder();
        for (VideoModel videoModel : resource.getVideos()) {
            idempotentImportExecutor.importAndSwallowIOExceptions((ImportableItem)videoModel, video -> {
                ItemImportResult<String> fileImportResult = this.importSingleVideo(videoModel, jobId, idempotentImportExecutor, koofrClient);
                if (fileImportResult != null && fileImportResult.hasBytes()) {
                    totalImportedFilesSizes.add(fileImportResult.getBytes());
                }
                return fileImportResult;
            });
        }
        return ImportResult.OK.copyWithBytes(Long.valueOf(totalImportedFilesSizes.longValue()));
    }

    private String createAlbumFolder(VideoAlbum album, KoofrClient koofrClient) throws IOException, InvalidTokenException {
        String albumName = KoofrTransmogrificationConfig.getAlbumName(album.getName());
        this.monitor.debug(() -> String.format("Create Koofr folder %s", albumName), new Object[0]);
        String rootPath = koofrClient.ensureRootFolder();
        String fullPath = rootPath + "/" + albumName;
        koofrClient.ensureFolder(rootPath, albumName);
        String description = KoofrClient.trimDescription(album.getDescription());
        if (description != null && description.length() > 0) {
            koofrClient.addDescription(fullPath, description);
        }
        return fullPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ItemImportResult<String> importSingleVideo(VideoModel video, UUID jobId, IdempotentImportExecutor idempotentImportExecutor, KoofrClient koofrClient) throws IOException, InvalidTokenException, DestinationMemoryFullException {
        this.monitor.debug(() -> String.format("Import single video %s", video.getName()), new Object[0]);
        try {
            TemporaryPerJobDataStore.InputStreamWrapper inputStreamWrapper = this.connectionProvider.getInputStreamForItem(jobId, (DownloadableItem)video);
            try (InputStream inputStream = inputStreamWrapper.getStream();){
                ItemImportResult response;
                String parentPath = video.getAlbumId() == null ? koofrClient.ensureVideosFolder() : (String)((Object)idempotentImportExecutor.getCachedValue(video.getAlbumId()));
                String name = video.getName();
                String description = KoofrClient.trimDescription(video.getDescription());
                String fullPath = parentPath + "/" + name;
                if (koofrClient.fileExists(fullPath)) {
                    this.monitor.debug(() -> String.format("Video already exists %s", video.getName()), new Object[0]);
                    ItemImportResult itemImportResult = ItemImportResult.success((Serializable)((Object)fullPath));
                    return itemImportResult;
                }
                long inputStreamBytes = inputStreamWrapper.getBytes();
                String responseResult = koofrClient.uploadFile(parentPath, name, inputStream, video.getEncodingFormat(), video.getUploadedTime(), description);
                if (responseResult != null && !responseResult.isEmpty()) {
                    response = ItemImportResult.success((Serializable)((Object)responseResult), (Long)inputStreamBytes);
                    return response;
                }
                response = ItemImportResult.success((Serializable)((Object)String.format(SKIPPED_FILE_RESULT_FORMAT, video.getDataId())));
                return response;
            }
        }
        catch (FileNotFoundException e) {
            this.monitor.info(() -> String.format("Video resource was missing for id: %s", video.getDataId()), new Object[]{e});
            return ItemImportResult.success((Serializable)((Object)String.format(SKIPPED_FILE_RESULT_FORMAT, video.getDataId())));
        }
    }
}

