/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.koofr.common;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public class InputStreamRequestBody
extends RequestBody {
    private final InputStream inputStream;
    private final MediaType contentType;

    public InputStreamRequestBody(MediaType contentType, InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream == null");
        }
        this.contentType = contentType;
        this.inputStream = inputStream;
    }

    @Nullable
    public MediaType contentType() {
        return this.contentType;
    }

    public long contentLength() throws IOException {
        return -1L;
    }

    public void writeTo(BufferedSink sink) throws IOException {
        try (Source source = null;){
            source = Okio.source((InputStream)this.inputStream);
            sink.writeAll(source);
        }
    }
}

