/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.microsoft.photos;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.auth.oauth2.Credential;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.spi.cloud.storage.TemporaryPerJobDataStore;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.provider.ImportResult;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.spi.transfer.types.CopyExceptionWithFailureReason;
import org.datatransferproject.spi.transfer.types.DestinationMemoryFullException;
import org.datatransferproject.spi.transfer.types.PermissionDeniedException;
import org.datatransferproject.transfer.microsoft.DataChunk;
import org.datatransferproject.transfer.microsoft.MicrosoftTransmogrificationConfig;
import org.datatransferproject.transfer.microsoft.common.MicrosoftCredentialFactory;
import org.datatransferproject.types.common.models.TransmogrificationConfig;
import org.datatransferproject.types.common.models.photos.PhotoAlbum;
import org.datatransferproject.types.common.models.photos.PhotoModel;
import org.datatransferproject.types.common.models.photos.PhotosContainerResource;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class MicrosoftPhotosImporter
implements Importer<TokensAndUrlAuthData, PhotosContainerResource> {
    private final OkHttpClient client;
    private final ObjectMapper objectMapper;
    private final TemporaryPerJobDataStore jobStore;
    private final Monitor monitor;
    private final MicrosoftCredentialFactory credentialFactory;
    private final MicrosoftTransmogrificationConfig transmogrificationConfig = new MicrosoftTransmogrificationConfig();
    private Credential credential;
    private final String createFolderUrl;
    private final String uploadPhotoUrlTemplate;
    private final String albumlessPhotoUrlTemplate;
    private static final String UPLOAD_PARAMS = "?@microsoft.graph.conflictBehavior=rename";

    public MicrosoftPhotosImporter(String baseUrl, OkHttpClient client, ObjectMapper objectMapper, TemporaryPerJobDataStore jobStore, Monitor monitor, MicrosoftCredentialFactory credentialFactory) {
        this.createFolderUrl = baseUrl + "/v1.0/me/drive/special/photos/children";
        this.uploadPhotoUrlTemplate = baseUrl + "/v1.0/me/drive/items/%s:/%s:/createUploadSession%s";
        this.albumlessPhotoUrlTemplate = baseUrl + "/v1.0/me/drive/special/photos:/%s:/createUploadSession%s";
        this.client = client;
        this.objectMapper = objectMapper;
        this.jobStore = jobStore;
        this.monitor = monitor;
        this.credentialFactory = credentialFactory;
        this.credential = null;
    }

    public ImportResult importItem(UUID jobId, IdempotentImportExecutor idempotentImportExecutor, TokensAndUrlAuthData authData, PhotosContainerResource resource) throws Exception {
        this.getOrCreateCredential(authData);
        this.monitor.debug(() -> String.format("%s: Importing %s albums and %s photos before transmogrification", jobId, resource.getAlbums().size(), resource.getPhotos().size()), new Object[0]);
        resource.transmogrify((TransmogrificationConfig)this.transmogrificationConfig);
        this.monitor.debug(() -> String.format("%s: Importing %s albums and %s photos after transmogrification", jobId, resource.getAlbums().size(), resource.getPhotos().size()), new Object[0]);
        for (PhotoAlbum album : resource.getAlbums()) {
            idempotentImportExecutor.executeAndSwallowIOExceptions(album.getId(), album.getName(), () -> this.createOneDriveFolder(album));
        }
        for (PhotoModel photoModel : resource.getPhotos()) {
            idempotentImportExecutor.executeAndSwallowIOExceptions(photoModel.getIdempotentId(), photoModel.getTitle(), () -> this.importSinglePhoto(photoModel, jobId, idempotentImportExecutor));
        }
        return ImportResult.OK;
    }

    private String createOneDriveFolder(PhotoAlbum album) throws IOException, CopyExceptionWithFailureReason {
        LinkedHashMap<String, Object> rawFolder = new LinkedHashMap<String, Object>();
        String albumName = Strings.isNullOrEmpty((String)album.getName()) ? "Untitled" : album.getName();
        rawFolder.put("name", albumName);
        rawFolder.put("folder", new LinkedHashMap());
        rawFolder.put("@microsoft.graph.conflictBehavior", "rename");
        Request.Builder requestBuilder = new Request.Builder().url(this.createFolderUrl);
        requestBuilder.header("Authorization", "Bearer " + this.credential.getAccessToken());
        requestBuilder.post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)this.objectMapper.writeValueAsString(rawFolder)));
        try (Response response = this.client.newCall(requestBuilder.build()).execute();){
            int code = response.code();
            ResponseBody body = response.body();
            if (code == 401) {
                this.credentialFactory.refreshCredential(this.credential);
                this.monitor.info(() -> "Refreshed authorization token successfuly", new Object[0]);
                requestBuilder.header("Authorization", "Bearer " + this.credential.getAccessToken());
                Response newResponse = this.client.newCall(requestBuilder.build()).execute();
                code = newResponse.code();
                body = newResponse.body();
            }
            if (code == 403 && response.message().contains("Access Denied")) {
                throw new PermissionDeniedException("User access to microsoft onedrive was denied", (Throwable)new IOException(String.format("Got error code %d  with message: %s", code, response.message())));
            }
            if (code < 200 || code > 299) {
                throw new IOException("Got error code: " + code + " message: " + response.message() + " body: " + response.body().string());
            }
            if (body == null) {
                throw new IOException("Got null body");
            }
            Map responseData = (Map)this.objectMapper.readValue(body.bytes(), Map.class);
            String folderId = (String)responseData.get("id");
            Preconditions.checkState((!Strings.isNullOrEmpty((String)folderId) ? 1 : 0) != 0, (String)"Expected id value to be present in %s", (Object)responseData);
            String string = folderId;
            return string;
        }
    }

    private String importSinglePhoto(PhotoModel photo, UUID jobId, IdempotentImportExecutor idempotentImportExecutor) throws Exception {
        BufferedInputStream inputStream = null;
        if (photo.isInTempStore()) {
            inputStream = new BufferedInputStream(this.jobStore.getStream(jobId, photo.getFetchableUrl()).getStream());
        } else if (photo.getFetchableUrl() != null) {
            inputStream = new BufferedInputStream(new URL(photo.getFetchableUrl()).openStream());
        } else {
            throw new IllegalStateException("Don't know how to get the inputStream for " + photo);
        }
        String photoUploadUrl = this.createUploadSession(photo, idempotentImportExecutor);
        List<DataChunk> chunksToSend = DataChunk.splitData(inputStream);
        inputStream.close();
        int totalFileSize = chunksToSend.stream().map(DataChunk::getSize).reduce(0, Integer::sum);
        Preconditions.checkState((chunksToSend.size() != 0 ? 1 : 0) != 0, (String)"Data was split into zero chunks %s.", (Object)photo.getTitle());
        Response chunkResponse = null;
        for (DataChunk chunk : chunksToSend) {
            chunkResponse = this.uploadChunk(chunk, photoUploadUrl, totalFileSize, photo.getMediaType());
        }
        if (chunkResponse.code() != 200 && chunkResponse.code() != 201) {
            this.monitor.debug(() -> "Received a bad code on completion of uploading chunks", new Object[]{chunkResponse.code()});
        }
        ResponseBody chunkResponseBody = chunkResponse.body();
        Map chunkResponseData = (Map)this.objectMapper.readValue(chunkResponseBody.bytes(), Map.class);
        return (String)chunkResponseData.get("id");
    }

    private Credential getOrCreateCredential(TokensAndUrlAuthData authData) {
        if (this.credential == null) {
            this.credential = this.credentialFactory.createCredential(authData);
        }
        return this.credential;
    }

    private String createUploadSession(PhotoModel photo, IdempotentImportExecutor idempotentImportExecutor) throws IOException, CopyExceptionWithFailureReason {
        String createSessionUrl;
        if (Strings.isNullOrEmpty((String)photo.getAlbumId())) {
            createSessionUrl = String.format(this.albumlessPhotoUrlTemplate, photo.getTitle(), UPLOAD_PARAMS);
        } else {
            String oneDriveFolderId = (String)((Object)idempotentImportExecutor.getCachedValue(photo.getAlbumId()));
            createSessionUrl = String.format(this.uploadPhotoUrlTemplate, oneDriveFolderId, photo.getTitle(), UPLOAD_PARAMS);
        }
        Request.Builder createSessionRequestBuilder = new Request.Builder().url(createSessionUrl);
        createSessionRequestBuilder.header("Authorization", "Bearer " + this.credential.getAccessToken());
        createSessionRequestBuilder.header("Content-Type", "application/json");
        createSessionRequestBuilder.post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)this.objectMapper.writeValueAsString((Object)ImmutableMap.of())));
        Response response = this.client.newCall(createSessionRequestBuilder.build()).execute();
        int code = response.code();
        ResponseBody responseBody = response.body();
        if (code == 401) {
            this.credentialFactory.refreshCredential(this.credential);
            this.monitor.info(() -> "Refreshed authorization token successfuly", new Object[0]);
            createSessionRequestBuilder.header("Authorization", "Bearer " + this.credential.getAccessToken());
            Response newResponse = this.client.newCall(createSessionRequestBuilder.build()).execute();
            code = newResponse.code();
            responseBody = newResponse.body();
        }
        if (code == 403 && response.message().contains("Access Denied")) {
            throw new PermissionDeniedException("User access to Microsoft One Drive was denied", (Throwable)new IOException(String.format("Got error code %d  with message: %s", code, response.message())));
        }
        if (code == 507 && response.message().contains("Insufficient Storage")) {
            throw new DestinationMemoryFullException("Microsoft destination storage limit reached", (Throwable)new IOException(String.format("Got error code %d  with message: %s", code, response.message())));
        }
        if (code < 200 || code > 299) {
            throw new IOException(String.format("Got error code: %s\nmessage: %s\nbody: %s\nrequest url: %s\nbearer token: %s\n photo: %s\n", code, response.message(), response.body().string(), createSessionUrl, this.credential.getAccessToken(), photo));
        }
        if (code != 200) {
            this.monitor.info(() -> String.format("Got an unexpected non-200, non-error response code", new Object[0]), new Object[0]);
        }
        Preconditions.checkState((responseBody != null ? 1 : 0) != 0, (String)"Got Null Body when creating photo upload session %s", (Object)photo);
        Map responseData = (Map)this.objectMapper.readValue(responseBody.bytes(), Map.class);
        Preconditions.checkState((boolean)responseData.containsKey("uploadUrl"), (Object)"No uploadUrl :(");
        return (String)responseData.get("uploadUrl");
    }

    private Response uploadChunk(DataChunk chunk, String photoUploadUrl, int totalFileSize, String mediaType) throws IOException, DestinationMemoryFullException {
        int chunkCode;
        Request.Builder uploadRequestBuilder = new Request.Builder().url(photoUploadUrl);
        uploadRequestBuilder.header("Authorization", "Bearer " + this.credential.getAccessToken());
        RequestBody uploadChunkBody = RequestBody.create((MediaType)MediaType.parse((String)mediaType), (byte[])chunk.getData(), (int)0, (int)chunk.getSize());
        uploadRequestBuilder.put(uploadChunkBody);
        String contentRange = String.format("bytes %d-%d/%d", chunk.getStart(), chunk.getEnd(), totalFileSize);
        uploadRequestBuilder.header("Content-Range", contentRange);
        uploadRequestBuilder.header("Content-Length", String.format("%d", chunk.getSize()));
        Response chunkResponse = this.client.newCall(uploadRequestBuilder.build()).execute();
        Preconditions.checkNotNull((Object)chunkResponse, (Object)"chunkResponse is null");
        if (chunkResponse.code() == 401) {
            this.credentialFactory.refreshCredential(this.credential);
            this.monitor.info(() -> "Refreshed authorization token successfuly", new Object[0]);
            uploadRequestBuilder.header("Authorization", "Bearer " + this.credential.getAccessToken());
            chunkResponse = this.client.newCall(uploadRequestBuilder.build()).execute();
        }
        if ((chunkCode = chunkResponse.code()) == 507 && chunkResponse.message().contains("Insufficient Storage")) {
            throw new DestinationMemoryFullException("Microsoft destination storage limit reached", (Throwable)new IOException(String.format("Got error code %d  with message: %s", chunkCode, chunkResponse.message())));
        }
        if (chunkCode < 200 || chunkCode > 299) {
            throw new IOException("Got error code: " + chunkCode + " message: " + chunkResponse.message() + " body: " + chunkResponse.body().string());
        }
        if (chunkCode == 200 || chunkCode == 201 || chunkCode == 202) {
            this.monitor.info(() -> String.format("Uploaded chunk %s-%s successfuly, code %d", chunk.getStart(), chunk.getEnd(), chunkCode), new Object[0]);
        }
        return chunkResponse;
    }
}

