/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.microsoft;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import okhttp3.OkHttpClient;
import org.datatransferproject.api.launcher.ExtensionContext;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.spi.api.transport.JobFileStream;
import org.datatransferproject.spi.cloud.storage.AppCredentialStore;
import org.datatransferproject.spi.cloud.storage.TemporaryPerJobDataStore;
import org.datatransferproject.spi.transfer.extension.TransferExtension;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.transfer.microsoft.calendar.MicrosoftCalendarExporter;
import org.datatransferproject.transfer.microsoft.calendar.MicrosoftCalendarImporter;
import org.datatransferproject.transfer.microsoft.common.MicrosoftCredentialFactory;
import org.datatransferproject.transfer.microsoft.contacts.MicrosoftContactsExporter;
import org.datatransferproject.transfer.microsoft.contacts.MicrosoftContactsImporter;
import org.datatransferproject.transfer.microsoft.media.MicrosoftMediaExporter;
import org.datatransferproject.transfer.microsoft.media.MicrosoftMediaImporter;
import org.datatransferproject.transfer.microsoft.offline.MicrosoftOfflineDataExporter;
import org.datatransferproject.transfer.microsoft.photos.MicrosoftPhotosExporter;
import org.datatransferproject.transfer.microsoft.photos.MicrosoftPhotosImporter;
import org.datatransferproject.transfer.microsoft.transformer.TransformerServiceImpl;
import org.datatransferproject.types.common.models.DataVertical;
import org.datatransferproject.types.transfer.auth.AppCredentials;

public class MicrosoftTransferExtension
implements TransferExtension {
    public static final String SERVICE_ID = "microsoft";
    private static final ImmutableList<DataVertical> SUPPORTED_IMPORT_SERVICES = ImmutableList.of((Object)DataVertical.CALENDAR, (Object)DataVertical.CONTACTS, (Object)DataVertical.PHOTOS, (Object)DataVertical.MEDIA);
    private static final ImmutableList<DataVertical> SUPPORTED_EXPORT_SERVICES = ImmutableList.of((Object)DataVertical.CALENDAR, (Object)DataVertical.CONTACTS, (Object)DataVertical.PHOTOS, (Object)DataVertical.MEDIA, (Object)DataVertical.OFFLINE_DATA);
    private ImmutableMap<DataVertical, Importer> importerMap;
    private ImmutableMap<DataVertical, Exporter> exporterMap;
    private static final String BASE_GRAPH_URL = "https://graph.microsoft.com";
    private final boolean offlineData = Boolean.parseBoolean(System.getProperty("offlineData"));
    private boolean initialized = false;

    public String getServiceId() {
        return SERVICE_ID;
    }

    public Exporter<?, ?> getExporter(DataVertical transferDataType) {
        Preconditions.checkState((boolean)this.initialized);
        if (!this.offlineData && transferDataType.equals((Object)DataVertical.OFFLINE_DATA)) {
            return null;
        }
        Preconditions.checkArgument((boolean)SUPPORTED_EXPORT_SERVICES.contains((Object)transferDataType));
        return (Exporter)this.exporterMap.get((Object)transferDataType);
    }

    public Importer<?, ?> getImporter(DataVertical transferDataType) {
        Preconditions.checkState((boolean)this.initialized);
        Preconditions.checkArgument((boolean)SUPPORTED_IMPORT_SERVICES.contains((Object)transferDataType));
        return (Importer)this.importerMap.get((Object)transferDataType);
    }

    public void initialize(ExtensionContext context) {
        AppCredentials appCredentials;
        if (this.initialized) {
            return;
        }
        double maxWritesPerSecond = (Double)context.getSetting("msoftMaxWritesPerSecond", (Object)1.0);
        TemporaryPerJobDataStore jobStore = (TemporaryPerJobDataStore)context.getService(TemporaryPerJobDataStore.class);
        HttpTransport httpTransport = (HttpTransport)context.getService(HttpTransport.class);
        JsonFactory jsonFactory = (JsonFactory)context.getService(JsonFactory.class);
        TransformerServiceImpl transformerService = new TransformerServiceImpl();
        OkHttpClient client = new OkHttpClient.Builder().build();
        ObjectMapper mapper = new ObjectMapper();
        try {
            appCredentials = ((AppCredentialStore)context.getService(AppCredentialStore.class)).getAppCredentials("MICROSOFT_KEY", "MICROSOFT_SECRET");
        }
        catch (IOException e) {
            Monitor monitor = context.getMonitor();
            monitor.info(() -> "Unable to retrieve Microsoft AppCredentials. Did you set MICROSOFT_KEY and MICROSOFT_SECRET?", new Object[0]);
            return;
        }
        MicrosoftCredentialFactory credentialFactory = new MicrosoftCredentialFactory(httpTransport, jsonFactory, appCredentials);
        JobFileStream jobFileStream = new JobFileStream();
        Monitor monitor = context.getMonitor();
        ImmutableMap.Builder importBuilder = ImmutableMap.builder();
        importBuilder.put((Object)DataVertical.CONTACTS, (Object)new MicrosoftContactsImporter(BASE_GRAPH_URL, client, mapper, transformerService));
        importBuilder.put((Object)DataVertical.CALENDAR, (Object)new MicrosoftCalendarImporter(BASE_GRAPH_URL, client, mapper, transformerService));
        importBuilder.put((Object)DataVertical.PHOTOS, (Object)new MicrosoftPhotosImporter(BASE_GRAPH_URL, client, mapper, jobStore, monitor, credentialFactory, jobFileStream));
        importBuilder.put((Object)DataVertical.MEDIA, (Object)new MicrosoftMediaImporter(BASE_GRAPH_URL, client, mapper, jobStore, monitor, credentialFactory, jobFileStream, maxWritesPerSecond));
        this.importerMap = importBuilder.build();
        ImmutableMap.Builder exporterBuilder = ImmutableMap.builder();
        exporterBuilder.put((Object)DataVertical.CONTACTS, (Object)new MicrosoftContactsExporter(BASE_GRAPH_URL, client, mapper, transformerService));
        exporterBuilder.put((Object)DataVertical.CALENDAR, (Object)new MicrosoftCalendarExporter(BASE_GRAPH_URL, client, mapper, transformerService));
        exporterBuilder.put((Object)DataVertical.PHOTOS, (Object)new MicrosoftPhotosExporter(credentialFactory, jsonFactory, monitor));
        exporterBuilder.put((Object)DataVertical.MEDIA, (Object)new MicrosoftMediaExporter(credentialFactory, jsonFactory, monitor));
        exporterBuilder.put((Object)DataVertical.OFFLINE_DATA, (Object)new MicrosoftOfflineDataExporter(BASE_GRAPH_URL, client, mapper));
        this.exporterMap = exporterBuilder.build();
        this.initialized = true;
    }
}

