/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.microsoft.transformer.contacts;

import ezvcard.VCard;
import ezvcard.parameter.TelephoneType;
import ezvcard.property.Email;
import ezvcard.property.Expertise;
import ezvcard.property.Organization;
import ezvcard.property.StructuredName;
import ezvcard.property.Telephone;
import ezvcard.property.Title;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.datatransferproject.transfer.microsoft.transformer.TransformerContext;
import org.datatransferproject.transfer.microsoft.transformer.common.TransformerHelper;

public class ToGraphContactTransformer
implements BiFunction<VCard, TransformerContext, Map<String, Object>> {
    @Override
    public Map<String, Object> apply(VCard card, TransformerContext context) {
        LinkedHashMap<String, Object> contact = new LinkedHashMap<String, Object>();
        this.copyNames(card, contact);
        this.copyPersonData(card, contact, context);
        this.copyBusinessData(card, contact);
        this.copyExtendedData(card, contact);
        return contact;
    }

    private void copyNames(VCard card, Map<String, Object> contact) {
        StructuredName structuredName = card.getStructuredName();
        if (structuredName != null) {
            TransformerHelper.safeSet("givenName", structuredName.getGiven(), contact);
            TransformerHelper.safeSet("surname", structuredName.getFamily(), contact);
            if (!structuredName.getAdditionalNames().isEmpty()) {
                TransformerHelper.safeSet("middleName", structuredName.getAdditionalNames().get(0), contact);
            }
            if (!structuredName.getPrefixes().isEmpty()) {
                TransformerHelper.safeSet("title", structuredName.getPrefixes().get(0), contact);
            }
        }
        TransformerHelper.safeSet("displayName", card.getFormattedName(), contact);
        TransformerHelper.safeSet("nickName", card.getNickname(), contact);
    }

    private void copyPersonData(VCard card, Map<String, Object> contact, TransformerContext context) {
        if (!card.getAddresses().isEmpty()) {
            TransformerHelper.safeSet("homeAddress", context.transform(LinkedHashMap.class, card.getAddresses().get(0)), contact);
        }
        card.getEmails().stream().filter(v -> v.getValue() != null).forEach(v -> this.addEmail((Email)v, contact));
        card.getTelephoneNumbers().stream().filter(t -> t.getText() != null).forEach(telephone -> {
            for (TelephoneType telephoneType : telephone.getTypes()) {
                if (TelephoneType.CELL.equals((Object)telephoneType)) {
                    contact.put("mobilePhone", telephone.getText());
                    continue;
                }
                if (TelephoneType.WORK.equals((Object)telephoneType)) {
                    this.addPhone("businessPhones", (Telephone)telephone, contact);
                    continue;
                }
                this.addPhone("homePhones", (Telephone)telephone, contact);
            }
        });
        if (card.getBirthday() != null) {
            TransformerHelper.safeSet("birthday", card.getBirthday().getText(), contact);
        }
    }

    private void copyBusinessData(VCard card, Map<String, Object> contact) {
        for (Title title : card.getTitles()) {
            if (title.getValue() == null) continue;
            if (title.getType() != null && title.getType().equalsIgnoreCase("home")) {
                TransformerHelper.safeSet("title", card.getTitles(), contact);
                continue;
            }
            TransformerHelper.safeSet("jobTitle", card.getTitles(), contact);
        }
        for (Organization organization : card.getOrganizations()) {
            for (String orgName : organization.getValues()) {
                contact.put("companyName", orgName);
            }
        }
        for (Expertise expertise : card.getExpertise()) {
            if (expertise.getValue() == null) continue;
            contact.put("profession", expertise.getValue());
            break;
        }
    }

    private void copyExtendedData(VCard card, Map<String, Object> contact) {
        TransformerHelper.safeSet("manager", card.getExtendedProperty("X-Manager"), contact);
        TransformerHelper.safeSet("spouseName", card.getExtendedProperty("X-Spouse"), contact);
    }

    private void addPhone(String key, Telephone telephone, Map<String, Object> map) {
        List collection = (List)map.computeIfAbsent(key, k -> new ArrayList());
        collection.add(telephone.getText());
    }

    private void addEmail(Email email, Map<String, Object> map) {
        List collection = (List)map.computeIfAbsent("emailAddresses", k -> new ArrayList());
        LinkedHashMap<String, String> emailMap = new LinkedHashMap<String, String>();
        emailMap.put("address", (String)email.getValue());
        collection.add(emailMap);
    }
}

