/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.microsoft;

import java.util.Arrays;
import org.datatransferproject.transfer.microsoft.DataChunk;

final class AutoValue_DataChunk
extends DataChunk {
    private final byte[] chunk;
    private final long streamByteOffset;

    private AutoValue_DataChunk(byte[] chunk, long streamByteOffset) {
        this.chunk = chunk;
        this.streamByteOffset = streamByteOffset;
    }

    @Override
    public byte[] chunk() {
        return this.chunk;
    }

    @Override
    public long streamByteOffset() {
        return this.streamByteOffset;
    }

    public String toString() {
        return "DataChunk{chunk=" + Arrays.toString(this.chunk) + ", streamByteOffset=" + this.streamByteOffset + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DataChunk) {
            DataChunk that = (DataChunk)o;
            return Arrays.equals(this.chunk, that instanceof AutoValue_DataChunk ? ((AutoValue_DataChunk)that).chunk : that.chunk()) && this.streamByteOffset == that.streamByteOffset();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= Arrays.hashCode(this.chunk);
        h$ *= 1000003;
        return h$ ^= (int)(this.streamByteOffset >>> 32 ^ this.streamByteOffset);
    }

    static final class Builder
    extends DataChunk.Builder {
        private byte[] chunk;
        private Long streamByteOffset;

        Builder() {
        }

        @Override
        public DataChunk.Builder setChunk(byte[] chunk) {
            if (chunk == null) {
                throw new NullPointerException("Null chunk");
            }
            this.chunk = chunk;
            return this;
        }

        @Override
        public DataChunk.Builder setStreamByteOffset(long streamByteOffset) {
            this.streamByteOffset = streamByteOffset;
            return this;
        }

        @Override
        public DataChunk build() {
            if (this.chunk == null || this.streamByteOffset == null) {
                StringBuilder missing = new StringBuilder();
                if (this.chunk == null) {
                    missing.append(" chunk");
                }
                if (this.streamByteOffset == null) {
                    missing.append(" streamByteOffset");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_DataChunk(this.chunk, this.streamByteOffset);
        }
    }
}

