/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.microsoft;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import okhttp3.Response;
import org.datatransferproject.spi.transfer.types.DestinationMemoryFullException;
import org.datatransferproject.spi.transfer.types.PermissionDeniedException;
import org.datatransferproject.transfer.microsoft.AutoValue_MicrosoftApiResponse;

@AutoValue
public abstract class MicrosoftApiResponse {
    @VisibleForTesting
    public static final String CAUSE_PREFIX_UNRECOGNIZED_EXCEPTION = "unrecognized class of Microsoft API error";

    public abstract int httpStatus();

    public abstract String httpMessage();

    public abstract Optional<String> body();

    public abstract Optional<IOException> bodyException();

    public static MicrosoftApiResponse ofResponse(Response response) throws IOException {
        Builder builder = MicrosoftApiResponse.builder().setHttpMessage(response.message()).setHttpStatus(response.code());
        if (response.body() != null) {
            try {
                String body = response.body().string();
                if (!Strings.isNullOrEmpty((String)body)) {
                    builder.setBody(body);
                }
            }
            catch (IOException e) {
                builder.setBodyException(e);
            }
            response.close();
        }
        return builder.build();
    }

    public static Builder builder() {
        return new AutoValue_MicrosoftApiResponse.Builder();
    }

    public Optional<RecoverableState> recoverableState() {
        if (this.isOkay()) {
            return Optional.of(RecoverableState.RECOVERABLE_STATE_OKAY);
        }
        if (this.isTokenRefreshRequired()) {
            return Optional.of(RecoverableState.RECOVERABLE_STATE_NEEDS_TOKEN_REFRESH);
        }
        return Optional.empty();
    }

    private boolean hasRecovery() {
        return this.recoverableState().isPresent();
    }

    public boolean isOkay() {
        return this.httpStatus() >= 200 && this.httpStatus() <= 299;
    }

    public boolean isTokenRefreshRequired() {
        return this.httpStatus() == 401 && this.bodyContains("InvalidAuthenticationToken");
    }

    private boolean isFatal() {
        return !this.hasRecovery();
    }

    public void throwDtpException(String message) throws IOException, DestinationMemoryFullException, PermissionDeniedException {
        switch (this.toFatalState()) {
            case FATAL_STATE_FATAL_PERMISSION_DENIED: {
                throw new PermissionDeniedException("User access to microsoft onedrive was denied", (Throwable)this.toIoException(message));
            }
            case FATAL_STATE_FATAL_DESTINATION_FULL: {
                throw new DestinationMemoryFullException("Microsoft destination storage limit reached", (Throwable)this.toIoException(message));
            }
            case FATAL_STATE_FATAL_UNSPECIFIED: {
                throw this.toIoException(String.format("%s: %s", CAUSE_PREFIX_UNRECOGNIZED_EXCEPTION, message));
            }
        }
        throw new AssertionError((Object)"exhaustive switch");
    }

    public MicrosoftApiResponse returnConvertDtpException(String message) throws IOException, DestinationMemoryFullException, PermissionDeniedException {
        this.throwDtpException(message);
        throw new AssertionError((Object)String.format("bug: throwDtpException should have thrown for failed response state: %s", message));
    }

    private FatalState toFatalState() {
        Preconditions.checkState((boolean)this.isFatal(), (Object)"cannot explain fatal state when is apparently recoverable");
        if (this.httpStatus() == 403 && (this.bodyContains("accessDenied") || this.bodyContains("notAllowed"))) {
            return FatalState.FATAL_STATE_FATAL_PERMISSION_DENIED;
        }
        if (this.httpStatus() == 507 && (this.bodyContains("Insufficient Space Available") || this.bodyContains("quotaLimitReached"))) {
            return FatalState.FATAL_STATE_FATAL_DESTINATION_FULL;
        }
        return FatalState.FATAL_STATE_FATAL_UNSPECIFIED;
    }

    public IOException toIoException() {
        return new IOException(this.toString());
    }

    public IOException toIoException(String message) {
        return new IOException(String.format("%s: %s", message, this.toString()));
    }

    private IOException toIoException(String message, Exception e) {
        return new IOException(String.format("%s: %s", message, this.toString()), e);
    }

    public String getJsonValue(ObjectMapper objectMapper, String jsonTopKey, String causeMessage) throws IOException {
        Map json;
        String responseBody = this.checkResponseBody(causeMessage);
        try {
            json = (Map)objectMapper.readValue(responseBody, Map.class);
        }
        catch (IOException e) {
            throw this.toIoException(causeMessage, e);
        }
        Preconditions.checkState((boolean)json.containsKey(jsonTopKey), (String)"response body missing top-level JSON field \"%s\"", (Object)jsonTopKey);
        String jsonValue = (String)json.get(jsonTopKey);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)jsonValue) ? 1 : 0) != 0, (String)"Expected JSON value for key \"%s\" to be present in in JSON body: %s", (Object)jsonTopKey, (Object)json);
        return jsonValue;
    }

    private String checkResponseBody(String causeMessage) throws IOException {
        return this.body().orElseThrow(() -> {
            String causeWithContext = String.format("HTTP response-body unexpectedly empty: %s", causeMessage);
            if (this.bodyException().isPresent()) {
                return this.toIoException(causeWithContext, this.bodyException().get());
            }
            return this.toIoException(causeWithContext);
        });
    }

    private boolean bodyContains(String needle) {
        return this.body().isPresent() && this.body().get().contains(needle);
    }

    public static enum FatalState {
        FATAL_STATE_FATAL_PERMISSION_DENIED,
        FATAL_STATE_FATAL_DESTINATION_FULL,
        FATAL_STATE_FATAL_UNSPECIFIED;

    }

    public static enum RecoverableState {
        RECOVERABLE_STATE_OKAY,
        RECOVERABLE_STATE_NEEDS_TOKEN_REFRESH;

    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setHttpStatus(int var1);

        public abstract Builder setHttpMessage(String var1);

        public abstract Builder setBody(String var1);

        public abstract Builder setBodyException(IOException var1);

        public abstract MicrosoftApiResponse build();
    }
}

