/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.microsoft.photos;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.json.JsonFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.spi.transfer.provider.ExportResult;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.types.ContinuationData;
import org.datatransferproject.transfer.microsoft.common.MicrosoftCredentialFactory;
import org.datatransferproject.transfer.microsoft.driveModels.MicrosoftDriveItem;
import org.datatransferproject.transfer.microsoft.driveModels.MicrosoftDriveItemsResponse;
import org.datatransferproject.transfer.microsoft.driveModels.MicrosoftSpecialFolder;
import org.datatransferproject.transfer.microsoft.photos.MicrosoftPhotosInterface;
import org.datatransferproject.types.common.ExportInformation;
import org.datatransferproject.types.common.PaginationData;
import org.datatransferproject.types.common.StringPaginationToken;
import org.datatransferproject.types.common.models.ContainerResource;
import org.datatransferproject.types.common.models.DataModel;
import org.datatransferproject.types.common.models.IdOnlyContainerResource;
import org.datatransferproject.types.common.models.photos.PhotoAlbum;
import org.datatransferproject.types.common.models.photos.PhotoModel;
import org.datatransferproject.types.common.models.photos.PhotosContainerResource;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class MicrosoftPhotosExporter
implements Exporter<TokensAndUrlAuthData, PhotosContainerResource> {
    static final String DRIVE_TOKEN_PREFIX = "drive:";
    private final MicrosoftCredentialFactory credentialFactory;
    private final JsonFactory jsonFactory;
    private final Monitor monitor;
    private volatile MicrosoftPhotosInterface photosInterface;

    public MicrosoftPhotosExporter(MicrosoftCredentialFactory credentialFactory, JsonFactory jsonFactory, Monitor monitor) {
        this.credentialFactory = credentialFactory;
        this.jsonFactory = jsonFactory;
        this.monitor = monitor;
    }

    @VisibleForTesting
    public MicrosoftPhotosExporter(MicrosoftCredentialFactory credentialFactory, JsonFactory jsonFactory, MicrosoftPhotosInterface photosInterface, Monitor monitor) {
        this.credentialFactory = credentialFactory;
        this.jsonFactory = jsonFactory;
        this.photosInterface = photosInterface;
        this.monitor = monitor;
    }

    public ExportResult<PhotosContainerResource> export(UUID jobId, TokensAndUrlAuthData authData, Optional<ExportInformation> exportInformation) throws IOException {
        if (!exportInformation.isPresent()) {
            return this.exportOneDrivePhotos(authData, Optional.empty(), Optional.empty(), jobId);
        }
        IdOnlyContainerResource idOnlyContainerResource = (IdOnlyContainerResource)exportInformation.get().getContainerResource();
        StringPaginationToken paginationToken = (StringPaginationToken)exportInformation.get().getPaginationData();
        return this.exportOneDrivePhotos(authData, Optional.ofNullable(idOnlyContainerResource), Optional.ofNullable(paginationToken), jobId);
    }

    @VisibleForTesting
    ExportResult<PhotosContainerResource> exportOneDrivePhotos(TokensAndUrlAuthData authData, Optional<IdOnlyContainerResource> albumData, Optional<PaginationData> paginationData, UUID jobId) throws IOException {
        Optional<String> albumId = Optional.empty();
        if (albumData.isPresent()) {
            albumId = Optional.of(albumData.get().getId());
        }
        Optional<String> paginationUrl = this.getDrivePaginationToken(paginationData);
        MicrosoftDriveItemsResponse driveItemsResponse = paginationData.isPresent() || albumData.isPresent() ? this.getOrCreatePhotosInterface(authData).getDriveItems(albumId, paginationUrl) : this.getOrCreatePhotosInterface(authData).getDriveItemsFromSpecialFolder(MicrosoftSpecialFolder.FolderType.photos);
        PaginationData nextPageData = this.setNextPageToken(driveItemsResponse);
        ContinuationData continuationData = new ContinuationData(nextPageData);
        MicrosoftDriveItem[] driveItems = driveItemsResponse.getDriveItems();
        ArrayList<PhotoAlbum> albums = new ArrayList<PhotoAlbum>();
        ArrayList<PhotoModel> photos = new ArrayList<PhotoModel>();
        if (driveItems != null && driveItems.length > 0) {
            for (MicrosoftDriveItem driveItem : driveItems) {
                PhotoModel photo;
                PhotoAlbum album = this.tryConvertDriveItemToPhotoAlbum(driveItem, jobId);
                if (album != null) {
                    albums.add(album);
                    continuationData.addContainerResource((ContainerResource)new IdOnlyContainerResource(driveItem.id));
                }
                if ((photo = this.tryConvertDriveItemToPhotoModel(albumId, driveItem, jobId)) == null) continue;
                photos.add(photo);
            }
        }
        ExportResult.ResultType result = nextPageData == null ? ExportResult.ResultType.END : ExportResult.ResultType.CONTINUE;
        PhotosContainerResource containerResource = new PhotosContainerResource(albums, photos);
        return new ExportResult(result, (DataModel)containerResource, continuationData);
    }

    private PhotoAlbum tryConvertDriveItemToPhotoAlbum(MicrosoftDriveItem driveItem, UUID jobId) {
        if (driveItem.folder != null) {
            PhotoAlbum photoAlbum = new PhotoAlbum(driveItem.id, driveItem.name, driveItem.description);
            this.monitor.debug(() -> String.format("%s: Microsoft OneDrive exporting album: %s", jobId, photoAlbum), new Object[0]);
            return photoAlbum;
        }
        return null;
    }

    private PhotoModel tryConvertDriveItemToPhotoModel(Optional<String> albumId, MicrosoftDriveItem driveItem, UUID jobId) {
        if (driveItem.file != null && driveItem.file.mimeType != null && driveItem.file.mimeType.startsWith("image/")) {
            PhotoModel photo = new PhotoModel(driveItem.name, driveItem.downloadUrl, driveItem.description, driveItem.file.mimeType, driveItem.id, (String)albumId.orElse(null), false);
            this.monitor.debug(() -> String.format("%s: Microsoft OneDrive exporting photo: %s", jobId, photo), new Object[0]);
            return photo;
        }
        return null;
    }

    private PaginationData setNextPageToken(MicrosoftDriveItemsResponse driveItemsResponse) {
        String url = driveItemsResponse.getNextPageLink();
        if (!Strings.isNullOrEmpty((String)url)) {
            return new StringPaginationToken(DRIVE_TOKEN_PREFIX + url);
        }
        return null;
    }

    private Optional<String> getDrivePaginationToken(Optional<PaginationData> paginationData) {
        return this.getPaginationToken(paginationData, DRIVE_TOKEN_PREFIX);
    }

    private Optional<String> getPaginationToken(Optional<PaginationData> paginationData, String tokenPrefix) {
        Optional<String> paginationToken = Optional.empty();
        if (paginationData.isPresent()) {
            String token = ((StringPaginationToken)paginationData.get()).getToken();
            Preconditions.checkArgument((boolean)token.startsWith(tokenPrefix), (Object)("Invalid pagination token " + token));
            if (token.length() > tokenPrefix.length()) {
                paginationToken = Optional.of(token.substring(tokenPrefix.length()));
            }
        }
        return paginationToken;
    }

    private synchronized MicrosoftPhotosInterface getOrCreatePhotosInterface(TokensAndUrlAuthData authData) {
        return this.photosInterface == null ? this.makePhotosInterface(authData) : this.photosInterface;
    }

    private synchronized MicrosoftPhotosInterface makePhotosInterface(TokensAndUrlAuthData authData) {
        Credential credential = this.credentialFactory.createCredential(authData);
        return new MicrosoftPhotosInterface(credential, this.jsonFactory);
    }
}

