/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.smugmug.media;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.spi.cloud.storage.TemporaryPerJobDataStore;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.provider.ImportResult;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.transfer.smugmug.SmugMugInterface;
import org.datatransferproject.transfer.smugmug.SmugMugTransmogrificationConfig;
import org.datatransferproject.transfer.smugmug.photos.SmugMugPhotoTempData;
import org.datatransferproject.transfer.smugmug.photos.model.SmugMugAlbumResponse;
import org.datatransferproject.transfer.smugmug.photos.model.SmugMugImageUploadResponse;
import org.datatransferproject.types.common.models.DataModel;
import org.datatransferproject.types.common.models.TransmogrificationConfig;
import org.datatransferproject.types.common.models.media.MediaAlbum;
import org.datatransferproject.types.common.models.media.MediaContainerResource;
import org.datatransferproject.types.common.models.photos.PhotoModel;
import org.datatransferproject.types.common.models.videos.VideoModel;
import org.datatransferproject.types.transfer.auth.AppCredentials;
import org.datatransferproject.types.transfer.auth.TokenSecretAuthData;

public class SmugMugMediaImporter
implements Importer<TokenSecretAuthData, MediaContainerResource> {
    private static final String DEFAULT_ALBUM_NAME = "Untitled Album";
    private final TemporaryPerJobDataStore jobStore;
    private final AppCredentials appCredentials;
    private final ObjectMapper mapper;
    private final Monitor monitor;
    private final SmugMugTransmogrificationConfig transmogrificationConfig;
    private final SmugMugInterface smugMugInterface;

    public SmugMugMediaImporter(TemporaryPerJobDataStore jobStore, AppCredentials appCredentials, ObjectMapper mapper, Monitor monitor) {
        this(null, new SmugMugTransmogrificationConfig(), jobStore, appCredentials, mapper, monitor);
    }

    @VisibleForTesting
    SmugMugMediaImporter(SmugMugInterface smugMugInterface, SmugMugTransmogrificationConfig transmogrificationConfig, TemporaryPerJobDataStore jobStore, AppCredentials appCredentials, ObjectMapper mapper, Monitor monitor) {
        this.smugMugInterface = smugMugInterface;
        this.transmogrificationConfig = transmogrificationConfig;
        this.jobStore = jobStore;
        this.appCredentials = appCredentials;
        this.mapper = mapper;
        this.monitor = monitor;
    }

    public ImportResult importItem(UUID jobId, IdempotentImportExecutor idempotentExecutor, TokenSecretAuthData authData, MediaContainerResource data) throws Exception {
        data.transmogrify((TransmogrificationConfig)this.transmogrificationConfig);
        try {
            SmugMugInterface smugMugInterface = this.getOrCreateSmugMugInterface(authData);
            for (MediaAlbum album : data.getAlbums()) {
                idempotentExecutor.executeAndSwallowIOExceptions(album.getId(), album.getName(), () -> this.importSingleAlbum(jobId, album, smugMugInterface));
            }
            for (PhotoModel photo : data.getPhotos()) {
                idempotentExecutor.executeAndSwallowIOExceptions(photo.getIdempotentId(), photo.getTitle(), () -> this.importSinglePhoto(jobId, idempotentExecutor, photo, smugMugInterface));
            }
            for (VideoModel video : data.getVideos()) {
                idempotentExecutor.executeAndSwallowIOExceptions(video.getIdempotentId(), video.getName(), () -> this.importSingleVideo(jobId, idempotentExecutor, video, smugMugInterface));
            }
        }
        catch (IOException e) {
            this.monitor.severe(() -> "Error importing", new Object[]{e});
            return new ImportResult((Throwable)e);
        }
        return ImportResult.OK;
    }

    @VisibleForTesting
    String importSingleAlbum(UUID jobId, MediaAlbum inputAlbum, SmugMugInterface smugMugInterface) throws IOException {
        String albumName = Strings.isNullOrEmpty((String)inputAlbum.getName()) ? DEFAULT_ALBUM_NAME : inputAlbum.getName();
        SmugMugAlbumResponse albumResponse = smugMugInterface.createAlbum(albumName);
        SmugMugPhotoTempData tempData = new SmugMugPhotoTempData(inputAlbum.getId(), albumName, inputAlbum.getDescription(), albumResponse.getUri());
        this.jobStore.create(jobId, SmugMugMediaImporter.getTempDataId(inputAlbum.getId()), (DataModel)tempData);
        return albumResponse.getUri();
    }

    @VisibleForTesting
    String importSinglePhoto(UUID jobId, IdempotentImportExecutor idempotentExecutor, PhotoModel inputPhoto, SmugMugInterface smugMugInterface) throws Exception {
        InputStream inputStream = inputPhoto.isInTempStore() ? this.jobStore.getStream(jobId, inputPhoto.getFetchableUrl()).getStream() : smugMugInterface.getImageAsStream(inputPhoto.getFetchableUrl());
        String originalAlbumId = inputPhoto.getAlbumId();
        SmugMugPhotoTempData albumTempData = this.getDestinationAlbumTempData(jobId, idempotentExecutor, originalAlbumId, smugMugInterface);
        SmugMugImageUploadResponse response = smugMugInterface.uploadImage(inputPhoto, albumTempData.getAlbumUri(), inputStream);
        albumTempData.incrementPhotoCount();
        this.jobStore.update(jobId, SmugMugMediaImporter.getTempDataId(albumTempData.getAlbumExportId()), (DataModel)albumTempData);
        return response.toString();
    }

    @VisibleForTesting
    String importSingleVideo(UUID jobId, IdempotentImportExecutor idempotentExecutor, VideoModel inputVideo, SmugMugInterface smugMugInterface) throws Exception {
        InputStream inputStream = inputVideo.isInTempStore() ? this.jobStore.getStream(jobId, inputVideo.getFetchableUrl()).getStream() : smugMugInterface.getImageAsStream(inputVideo.getFetchableUrl());
        String originalAlbumId = inputVideo.getAlbumId();
        SmugMugPhotoTempData albumTempData = this.getDestinationAlbumTempData(jobId, idempotentExecutor, originalAlbumId, smugMugInterface);
        SmugMugImageUploadResponse response = smugMugInterface.uploadVideo(inputVideo, albumTempData.getAlbumUri(), inputStream);
        albumTempData.incrementPhotoCount();
        this.jobStore.update(jobId, SmugMugMediaImporter.getTempDataId(albumTempData.getAlbumExportId()), (DataModel)albumTempData);
        return response.toString();
    }

    private SmugMugInterface getOrCreateSmugMugInterface(TokenSecretAuthData authData) throws IOException {
        return this.smugMugInterface == null ? new SmugMugInterface(this.appCredentials, authData, this.mapper) : this.smugMugInterface;
    }

    @VisibleForTesting
    SmugMugPhotoTempData getDestinationAlbumTempData(UUID jobId, IdempotentImportExecutor idempotentExecutor, String baseAlbumId, SmugMugInterface smugMugInterface) throws Exception {
        SmugMugPhotoTempData baseAlbumTempData;
        SmugMugPhotoTempData albumTempData = baseAlbumTempData = (SmugMugPhotoTempData)this.jobStore.findData(jobId, SmugMugMediaImporter.getTempDataId(baseAlbumId), SmugMugPhotoTempData.class);
        int depth = 0;
        while (albumTempData.getPhotoCount() >= this.transmogrificationConfig.getAlbumMaxSize()) {
            if (albumTempData.getOverflowAlbumExportId() == null) {
                MediaAlbum newAlbum = SmugMugMediaImporter.createOverflowAlbum(baseAlbumTempData.getAlbumExportId(), baseAlbumTempData.getAlbumName(), baseAlbumTempData.getAlbumDescription(), depth + 1);
                String newUri = (String)((Object)idempotentExecutor.executeOrThrowException(newAlbum.getId(), newAlbum.getName(), () -> this.importSingleAlbum(jobId, newAlbum, smugMugInterface)));
                albumTempData.setOverflowAlbumExportId(newAlbum.getId());
                this.jobStore.update(jobId, SmugMugMediaImporter.getTempDataId(albumTempData.getAlbumExportId()), (DataModel)albumTempData);
                albumTempData = (SmugMugPhotoTempData)this.jobStore.findData(jobId, SmugMugMediaImporter.getTempDataId(albumTempData.getOverflowAlbumExportId()), SmugMugPhotoTempData.class);
            } else {
                albumTempData = (SmugMugPhotoTempData)this.jobStore.findData(jobId, SmugMugMediaImporter.getTempDataId(albumTempData.getOverflowAlbumExportId()), SmugMugPhotoTempData.class);
            }
            ++depth;
        }
        return albumTempData;
    }

    private static String getTempDataId(String albumId) {
        return String.format("smugmug-album-temp-data-%s", albumId);
    }

    private static MediaAlbum createOverflowAlbum(String baseAlbumId, String baseAlbumName, String baseAlbumDescription, int copyNumber) throws Exception {
        Preconditions.checkState((copyNumber > 0 ? 1 : 0) != 0, (Object)"copyNumber should be > 0");
        return new MediaAlbum(String.format("%s-overflow-%d", baseAlbumId, copyNumber), String.format("%s (%d)", baseAlbumName, copyNumber), baseAlbumDescription);
    }
}

