/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.smugmug.photos;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.spi.cloud.storage.TemporaryPerJobDataStore;
import org.datatransferproject.spi.transfer.provider.ExportResult;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.types.ContinuationData;
import org.datatransferproject.transfer.smugmug.SmugMugInterface;
import org.datatransferproject.transfer.smugmug.photos.model.SmugMugAlbum;
import org.datatransferproject.transfer.smugmug.photos.model.SmugMugAlbumImageResponse;
import org.datatransferproject.transfer.smugmug.photos.model.SmugMugAlbumsResponse;
import org.datatransferproject.transfer.smugmug.photos.model.SmugMugImage;
import org.datatransferproject.types.common.ExportInformation;
import org.datatransferproject.types.common.StringPaginationToken;
import org.datatransferproject.types.common.models.ContainerResource;
import org.datatransferproject.types.common.models.DataModel;
import org.datatransferproject.types.common.models.IdOnlyContainerResource;
import org.datatransferproject.types.common.models.photos.PhotoAlbum;
import org.datatransferproject.types.common.models.photos.PhotoModel;
import org.datatransferproject.types.common.models.photos.PhotosContainerResource;
import org.datatransferproject.types.transfer.auth.AppCredentials;
import org.datatransferproject.types.transfer.auth.TokenSecretAuthData;

public class SmugMugPhotosExporter
implements Exporter<TokenSecretAuthData, PhotosContainerResource> {
    static final String ALBUM_TOKEN_PREFIX = "album:";
    static final String PHOTO_TOKEN_PREFIX = "photo:";
    private final AppCredentials appCredentials;
    private final ObjectMapper mapper;
    private final TemporaryPerJobDataStore jobStore;
    private final Monitor monitor;
    private SmugMugInterface smugMugInterface;

    public SmugMugPhotosExporter(AppCredentials appCredentials, ObjectMapper mapper, TemporaryPerJobDataStore jobStore, Monitor monitor) {
        this(null, appCredentials, mapper, jobStore, monitor);
    }

    @VisibleForTesting
    SmugMugPhotosExporter(SmugMugInterface smugMugInterface, AppCredentials appCredentials, ObjectMapper mapper, TemporaryPerJobDataStore jobStore, Monitor monitor) {
        this.appCredentials = appCredentials;
        this.smugMugInterface = smugMugInterface;
        this.mapper = mapper;
        this.jobStore = jobStore;
        this.monitor = monitor;
    }

    public ExportResult<PhotosContainerResource> export(UUID jobId, TokenSecretAuthData authData, Optional<ExportInformation> exportInformation) throws IOException {
        SmugMugInterface smugMugInterface;
        StringPaginationToken paginationToken = exportInformation.isPresent() ? (StringPaginationToken)exportInformation.get().getPaginationData() : null;
        IdOnlyContainerResource resource = exportInformation.isPresent() ? (IdOnlyContainerResource)exportInformation.get().getContainerResource() : null;
        try {
            smugMugInterface = this.getOrCreateSmugMugInterface(authData);
        }
        catch (IOException e) {
            this.monitor.severe(() -> "Unable to create Smugmug service for user", new Object[]{e});
            throw e;
        }
        if (resource != null) {
            return this.exportPhotos(resource, paginationToken, smugMugInterface, jobId);
        }
        return this.exportAlbums(paginationToken, smugMugInterface);
    }

    private ExportResult<PhotosContainerResource> exportAlbums(StringPaginationToken paginationData, SmugMugInterface smugMugInterface) throws IOException {
        SmugMugAlbumsResponse albumsResponse;
        try {
            String albumInfoUri = "";
            if (paginationData != null) {
                String pageToken = paginationData.getToken();
                Preconditions.checkState((boolean)pageToken.startsWith(ALBUM_TOKEN_PREFIX), (Object)("Invalid pagination token " + pageToken));
                albumInfoUri = pageToken.substring(ALBUM_TOKEN_PREFIX.length());
            }
            albumsResponse = smugMugInterface.getAlbums(albumInfoUri);
        }
        catch (IOException e) {
            this.monitor.severe(() -> "Unable to get AlbumsResponse: ", new Object[]{e});
            throw e;
        }
        StringPaginationToken paginationToken = null;
        if (albumsResponse.getPageInfo() != null && albumsResponse.getPageInfo().getNextPage() != null) {
            paginationToken = new StringPaginationToken(ALBUM_TOKEN_PREFIX + albumsResponse.getPageInfo().getNextPage());
        }
        ContinuationData continuationData = new ContinuationData(paginationToken);
        ArrayList<PhotoAlbum> albumsList = new ArrayList<PhotoAlbum>();
        if (albumsResponse.getAlbums() != null) {
            for (SmugMugAlbum album : albumsResponse.getAlbums()) {
                albumsList.add(new PhotoAlbum(album.getUri(), album.getName(), album.getDescription()));
                continuationData.addContainerResource((ContainerResource)new IdOnlyContainerResource(album.getUri()));
            }
        }
        PhotosContainerResource resource = new PhotosContainerResource(albumsList, null);
        ExportResult.ResultType resultType = ExportResult.ResultType.CONTINUE;
        if (paginationToken == null) {
            resultType = ExportResult.ResultType.END;
        }
        return new ExportResult(resultType, (DataModel)resource, continuationData);
    }

    private ExportResult<PhotosContainerResource> exportPhotos(IdOnlyContainerResource containerResource, StringPaginationToken paginationData, SmugMugInterface smugMugInterface, UUID jobId) throws IOException {
        SmugMugAlbumImageResponse albumImageList;
        String photoInfoUri;
        ArrayList<PhotoModel> photoList = new ArrayList<PhotoModel>();
        if (paginationData != null) {
            String token = paginationData.getToken();
            Preconditions.checkState((boolean)token.startsWith(PHOTO_TOKEN_PREFIX), (Object)("Invalid pagination token " + token));
            photoInfoUri = token.substring(PHOTO_TOKEN_PREFIX.length());
        } else {
            photoInfoUri = containerResource.getId();
        }
        try {
            albumImageList = smugMugInterface.getListOfAlbumImages(photoInfoUri + "!images");
        }
        catch (IOException e) {
            this.monitor.severe(() -> "Unable to get SmugMugAlbumImageResponse", new Object[0]);
            throw e;
        }
        StringPaginationToken pageToken = null;
        if (albumImageList.getPageInfo().getNextPage() != null) {
            pageToken = new StringPaginationToken(PHOTO_TOKEN_PREFIX + albumImageList.getPageInfo().getNextPage());
        }
        ContinuationData continuationData = new ContinuationData(pageToken);
        Object images = albumImageList.getAlbumImages() == null ? ImmutableList.of() : albumImageList.getAlbumImages();
        Iterator iterator = images.iterator();
        while (iterator.hasNext()) {
            SmugMugImage albumImage = (SmugMugImage)iterator.next();
            if (!albumImage.isPhoto().booleanValue()) continue;
            String title = albumImage.getTitle();
            if (Strings.isNullOrEmpty((String)title)) {
                title = albumImage.getFileName();
            }
            PhotoModel model = new PhotoModel(title, albumImage.getArchivedUri(), albumImage.getCaption(), this.getMimeType(albumImage.getFormat()), albumImage.getArchivedUri(), containerResource.getId(), true);
            InputStream inputStream = smugMugInterface.getImageAsStream(model.getFetchableUrl());
            this.jobStore.create(jobId, model.getFetchableUrl(), inputStream);
            photoList.add(model);
        }
        PhotosContainerResource resource = new PhotosContainerResource(null, photoList);
        ExportResult.ResultType resultType = ExportResult.ResultType.CONTINUE;
        if (pageToken == null) {
            resultType = ExportResult.ResultType.END;
        }
        return new ExportResult(resultType, (DataModel)resource, continuationData);
    }

    private SmugMugInterface getOrCreateSmugMugInterface(TokenSecretAuthData authData) throws IOException {
        return this.smugMugInterface == null ? new SmugMugInterface(this.appCredentials, authData, this.mapper) : this.smugMugInterface;
    }

    private String getMimeType(String smugMugformat) {
        switch (smugMugformat) {
            case "JPG": 
            case "JPEG": {
                return "image/jpeg";
            }
            case "PNG": {
                return "image/png";
            }
            case "GIF": {
                return "image/gif";
            }
        }
        throw new IllegalArgumentException("Don't know how to map: " + smugMugformat);
    }
}

