/*
 * Copyright 2018 The Data Transfer Project Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.datatransferproject.transfer.smugmug.photos.model;

import com.fasterxml.jackson.annotation.JsonProperty;

/** Results from https://api.smugmug.com/api/v2!authuser */
public class SmugMugUserResponse {

  @JsonProperty("Url")
  private String uri;

  @JsonProperty("Locator")
  private String locator;

  @JsonProperty("LocatorType")
  private String locatorType;

  @JsonProperty("User")
  private SmugMugUser user;

  public String getUri() {
    return uri;
  }

  public String getLocator() {
    return locator;
  }

  public String getLocatorType() {
    return locatorType;
  }

  public SmugMugUser getUser() {
    return user;
  }
}
