/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.smugmug;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.DefaultApi10a;
import com.github.scribejava.core.model.OAuth1AccessToken;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth10aService;
import com.google.api.client.http.InputStreamContent;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.datatransferproject.transfer.smugmug.photos.SmugMugOauthApi;
import org.datatransferproject.transfer.smugmug.photos.model.SmugMugAlbumImageResponse;
import org.datatransferproject.transfer.smugmug.photos.model.SmugMugAlbumResponse;
import org.datatransferproject.transfer.smugmug.photos.model.SmugMugAlbumsResponse;
import org.datatransferproject.transfer.smugmug.photos.model.SmugMugImageUploadResponse;
import org.datatransferproject.transfer.smugmug.photos.model.SmugMugResponse;
import org.datatransferproject.transfer.smugmug.photos.model.SmugMugUser;
import org.datatransferproject.transfer.smugmug.photos.model.SmugMugUserResponse;
import org.datatransferproject.types.common.models.photos.PhotoModel;
import org.datatransferproject.types.common.models.videos.VideoModel;
import org.datatransferproject.types.transfer.auth.AppCredentials;
import org.datatransferproject.types.transfer.auth.TokenSecretAuthData;

public class SmugMugInterface {
    private static final String BASE_URL = "https://api.smugmug.com";
    private static final String USER_URL = "/api/v2!authuser";
    private static final String ALBUMS_KEY = "UserAlbums";
    private static final String FOLDER_KEY = "Folder";
    private final OAuth10aService oAuthService;
    private final OAuth1AccessToken accessToken;
    private final ObjectMapper mapper;
    private final SmugMugUser user;

    public SmugMugInterface(AppCredentials appCredentials, TokenSecretAuthData authData, ObjectMapper mapper) throws IOException {
        this.oAuthService = new ServiceBuilder(appCredentials.getKey()).apiSecret(appCredentials.getSecret()).build((DefaultApi10a)new SmugMugOauthApi());
        this.accessToken = new OAuth1AccessToken(authData.getToken(), authData.getSecret());
        this.mapper = mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.user = this.getUserInformation().getUser();
    }

    public SmugMugAlbumImageResponse getListOfAlbumImages(String url) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)url) ? 1 : 0) != 0, (Object)"Album URI is required to retrieve album information");
        SmugMugAlbumImageResponse response = this.makeRequest(url, new TypeReference<SmugMugResponse<SmugMugAlbumImageResponse>>(){}).getResponse();
        return response;
    }

    public SmugMugAlbumsResponse getAlbums(String url) throws IOException {
        if (Strings.isNullOrEmpty((String)url)) {
            url = this.user.getUris().get(ALBUMS_KEY).getUri();
        }
        return this.makeRequest(url, new TypeReference<SmugMugResponse<SmugMugAlbumsResponse>>(){}).getResponse();
    }

    public SmugMugAlbumResponse createAlbum(String albumName) throws IOException {
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("NiceName", SmugMugInterface.cleanName(albumName));
        json.put("AutoRename", "true");
        json.put("Title", albumName);
        json.put("Privacy", "Private");
        String folder = this.user.getUris().get(FOLDER_KEY).getUri();
        SmugMugResponse<SmugMugAlbumResponse> response = this.postRequest(folder + "!albums", json, null, (Map<String, String>)ImmutableMap.of(), new TypeReference<SmugMugResponse<SmugMugAlbumResponse>>(){});
        Preconditions.checkState((response.getResponse() != null ? 1 : 0) != 0, (Object)"Response is null");
        Preconditions.checkState((response.getResponse().getAlbum() != null ? 1 : 0) != 0, (Object)"Album is null");
        return response.getResponse();
    }

    public SmugMugImageUploadResponse uploadImage(PhotoModel photoModel, String albumUri, InputStream inputStream) throws IOException {
        InputStreamContent content = new InputStreamContent(null, inputStream);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        content.writeTo((OutputStream)outputStream);
        byte[] contentBytes = outputStream.toByteArray();
        HashMap<String, String> headersMap = new HashMap<String, String>();
        headersMap.put("X-Smug-AlbumUri", albumUri);
        headersMap.put("X-Smug-ResponseType", "JSON");
        headersMap.put("X-Smug-Version", "v2");
        headersMap.put("Content-Type", photoModel.getMediaType());
        if (!Strings.isNullOrEmpty((String)photoModel.getTitle())) {
            headersMap.put("X-Smug-Title", SmugMugInterface.cleanHeader(photoModel.getTitle()));
        }
        if (!Strings.isNullOrEmpty((String)photoModel.getDescription())) {
            headersMap.put("X-Smug-Caption", SmugMugInterface.cleanHeader(photoModel.getDescription()));
        }
        SmugMugImageUploadResponse response = this.postRequest("https://upload.smugmug.com/", (Map<String, String>)ImmutableMap.of(), contentBytes, headersMap, new TypeReference<SmugMugImageUploadResponse>(){});
        Preconditions.checkState((boolean)response.getStat().equals("ok"), (Object)"Failed to upload image");
        return (SmugMugImageUploadResponse)Preconditions.checkNotNull((Object)response, (Object)"Image upload Response is null");
    }

    public SmugMugImageUploadResponse uploadVideo(VideoModel videoModel, String albumUri, InputStream inputStream) throws IOException {
        InputStreamContent content = new InputStreamContent(null, inputStream);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        content.writeTo((OutputStream)outputStream);
        byte[] contentBytes = outputStream.toByteArray();
        HashMap<String, String> headersMap = new HashMap<String, String>();
        headersMap.put("X-Smug-AlbumUri", albumUri);
        headersMap.put("X-Smug-ResponseType", "JSON");
        headersMap.put("X-Smug-Version", "v2");
        headersMap.put("Content-Type", videoModel.getMimeType());
        if (!Strings.isNullOrEmpty((String)videoModel.getName())) {
            headersMap.put("X-Smug-Title", SmugMugInterface.cleanHeader(videoModel.getName()));
        }
        if (!Strings.isNullOrEmpty((String)videoModel.getDescription())) {
            headersMap.put("X-Smug-Caption", SmugMugInterface.cleanHeader(videoModel.getDescription()));
        }
        SmugMugImageUploadResponse response = this.postRequest("https://upload.smugmug.com/", (Map<String, String>)ImmutableMap.of(), contentBytes, headersMap, new TypeReference<SmugMugImageUploadResponse>(){});
        Preconditions.checkState((boolean)response.getStat().equals("ok"), (Object)"Failed to upload image");
        return (SmugMugImageUploadResponse)Preconditions.checkNotNull((Object)response, (Object)"Image upload Response is null");
    }

    private SmugMugUserResponse getUserInformation() throws IOException {
        return this.makeRequest(USER_URL, new TypeReference<SmugMugResponse<SmugMugUserResponse>>(){}).getResponse();
    }

    public InputStream getImageAsStream(String urlStr) throws IOException {
        OAuthRequest request = new OAuthRequest(Verb.GET, urlStr);
        this.oAuthService.signRequest(this.accessToken, request);
        try {
            Response response = this.oAuthService.execute(request);
            return response.getStream();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
    }

    private <T> SmugMugResponse<T> makeRequest(String url, TypeReference<SmugMugResponse<T>> typeReference) throws IOException {
        Object fullUrl = !url.contains("https://") ? BASE_URL + url : url;
        fullUrl = (String)fullUrl + (url.contains("?") ? "&" : "?") + "_accept=application%2Fjson";
        OAuthRequest request = new OAuthRequest(Verb.GET, (String)fullUrl);
        this.oAuthService.signRequest(this.accessToken, request);
        try {
            Response response = this.oAuthService.execute(request);
            if (response.getCode() < 200 || response.getCode() >= 300) {
                throw new IOException(String.format("Error occurred in request for %s : %s", url, response.getMessage()));
            }
            return (SmugMugResponse)this.mapper.readValue(response.getBody(), typeReference);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
    }

    private <T> T postRequest(String url, Map<String, String> contentParams, @Nullable byte[] contentBytes, Map<String, String> smugMugHeaders, TypeReference<T> typeReference) throws IOException {
        Object fullUrl = url;
        if (!((String)fullUrl).contains("://")) {
            fullUrl = BASE_URL + url;
        }
        OAuthRequest request = new OAuthRequest(Verb.POST, (String)fullUrl);
        if (contentBytes != null) {
            request.setPayload(contentBytes);
        }
        for (Map.Entry<String, String> param : contentParams.entrySet()) {
            request.addBodyParameter(param.getKey(), param.getValue());
        }
        this.oAuthService.signRequest(this.accessToken, request);
        for (Map.Entry<String, String> header : smugMugHeaders.entrySet()) {
            request.addHeader(header.getKey(), header.getValue());
        }
        request.addHeader("Accept", "application/json");
        try {
            Response response = this.oAuthService.execute(request);
            if (response.getCode() < 200 || response.getCode() >= 300) {
                if (response.getCode() == 400) {
                    throw new IOException(String.format("Error occurred in request for %s, code: %s, message: %s, request: %s, bodyParams: %s, payload: %s", fullUrl, response.getCode(), response.getMessage(), request, request.getBodyParams(), new String(request.getByteArrayPayload(), request.getCharset())));
                }
                throw new IOException(String.format("Error occurred in request for %s, code: %s, message: %s", fullUrl, response.getCode(), response.getMessage()));
            }
            return (T)this.mapper.readValue(response.getBody(), typeReference);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
    }

    public static String cleanName(String name) {
        return name.chars().mapToObj(c -> Character.valueOf((char)c)).map(c -> Character.valueOf(Character.isWhitespace(c.charValue()) ? (char)'-' : (char)c.charValue())).filter(c -> Character.isLetterOrDigit(c.charValue()) || c.charValue() == '-').limit(40L).map(Object::toString).collect(Collectors.joining(""));
    }

    static String cleanHeader(String header) {
        return header.replace("\n", "%0A").replace("\r", "%0D");
    }
}

