/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.security.cleartext;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.datatransferproject.spi.transfer.security.AuthDataDecryptService;
import org.datatransferproject.types.transfer.auth.AuthDataPair;

public class ClearTextAuthDataDecryptService
implements AuthDataDecryptService {
    private final ObjectMapper objectMapper;

    public ClearTextAuthDataDecryptService(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean canHandle(String scheme) {
        return "cleartext".equals(scheme);
    }

    public AuthDataPair decrypt(String encrypted, byte[] encodedPrivateKey) {
        try {
            return (AuthDataPair)this.objectMapper.readValue(encrypted, AuthDataPair.class);
        }
        catch (IOException e) {
            throw new SecurityException("Error deserializing auth tokens", e);
        }
    }
}

