/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.security.cleartext;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.datatransferproject.api.launcher.ExtensionContext;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.api.launcher.TypeManager;
import org.datatransferproject.security.cleartext.ClearTextAuthDataDecryptService;
import org.datatransferproject.security.cleartext.ClearTextKeyGenerator;
import org.datatransferproject.security.cleartext.ClearTextPublicKeySerializer;
import org.datatransferproject.spi.transfer.security.AuthDataDecryptService;
import org.datatransferproject.spi.transfer.security.PublicKeySerializer;
import org.datatransferproject.spi.transfer.security.SecurityExtension;
import org.datatransferproject.spi.transfer.security.TransferKeyGenerator;

public class ClearTextSecurityExtension
implements SecurityExtension {
    private TypeManager typeManager;
    private Monitor monitor;

    public void initialize(ExtensionContext context) {
        this.typeManager = context.getTypeManager();
        this.monitor = context.getMonitor();
    }

    public TransferKeyGenerator getTransferKeyGenerator() {
        return new ClearTextKeyGenerator(this.monitor);
    }

    public PublicKeySerializer getPublicKeySerializer() {
        return new ClearTextPublicKeySerializer();
    }

    public AuthDataDecryptService getDecryptService() {
        ObjectMapper objectMapper = this.typeManager.getMapper();
        return new ClearTextAuthDataDecryptService(objectMapper);
    }
}

