/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.security.jwe;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.crypto.RSADecrypter;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.ParseException;
import org.datatransferproject.spi.transfer.security.AuthDataDecryptService;
import org.datatransferproject.types.transfer.auth.AuthDataPair;

public class JWEAuthDataDecryptService
implements AuthDataDecryptService {
    private final ObjectMapper objectMapper;

    public JWEAuthDataDecryptService(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean canHandle(String scheme) {
        return "jwe".equals(scheme);
    }

    public AuthDataPair decrypt(String encrypted, byte[] encodedPrivateKey) {
        PrivateKey privateKey = JWEAuthDataDecryptService.parse(encodedPrivateKey);
        return this.decrypt(encrypted, privateKey);
    }

    private AuthDataPair decrypt(String encrypted, PrivateKey privateKey) {
        try {
            RSADecrypter decrypter = new RSADecrypter(privateKey);
            JWEObject object = JWEObject.parse((String)encrypted);
            object.decrypt((JWEDecrypter)decrypter);
            return (AuthDataPair)this.objectMapper.readValue(object.getPayload().toString(), AuthDataPair.class);
        }
        catch (JOSEException | IOException | ParseException e) {
            throw new SecurityException("Error decrypting auth tokens", e);
        }
    }

    private static PrivateKey parse(byte[] encoded) {
        try {
            KeyFactory factory = KeyFactory.getInstance("RSA");
            return factory.generatePrivate(new PKCS8EncodedKeySpec(encoded));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException("InvalidKeySpecException generating PrivateKey, encoded: " + encoded, e);
        }
    }
}

