/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.security.jwe;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.datatransferproject.api.launcher.ExtensionContext;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.api.launcher.TypeManager;
import org.datatransferproject.security.jwe.JWEAuthDataDecryptService;
import org.datatransferproject.security.jwe.JWEKeyGenerator;
import org.datatransferproject.security.jwe.JWEPublicKeySerializer;
import org.datatransferproject.spi.transfer.security.AuthDataDecryptService;
import org.datatransferproject.spi.transfer.security.PublicKeySerializer;
import org.datatransferproject.spi.transfer.security.SecurityExtension;
import org.datatransferproject.spi.transfer.security.TransferKeyGenerator;

public class JWESecurityExtension
implements SecurityExtension {
    private TypeManager typeManager;
    private Monitor monitor;

    public void initialize(ExtensionContext context) {
        this.typeManager = context.getTypeManager();
        this.monitor = context.getMonitor();
    }

    public PublicKeySerializer getPublicKeySerializer() {
        return new JWEPublicKeySerializer();
    }

    public AuthDataDecryptService getDecryptService() {
        ObjectMapper objectMapper = this.typeManager.getMapper();
        return new JWEAuthDataDecryptService(objectMapper);
    }

    public TransferKeyGenerator getTransferKeyGenerator() {
        return new JWEKeyGenerator(this.monitor);
    }
}

