/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.spi.cloud.storage;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.UUID;
import org.datatransferproject.spi.cloud.storage.JobStore;
import org.datatransferproject.spi.cloud.types.JobAuthorization;
import org.datatransferproject.spi.cloud.types.PortabilityJob;
import org.datatransferproject.types.common.models.DataVertical;

public abstract class JobStoreWithValidator
implements JobStore {
    @Override
    public void claimJob(UUID jobId, PortabilityJob job) throws IOException {
        this.updateJob(jobId, job, (previous, updated) -> Preconditions.checkState((previous.jobAuthorization().state() == JobAuthorization.State.CREDS_AVAILABLE ? 1 : 0) != 0));
    }

    @Override
    public void updateJobAuthStateToCredsAvailable(UUID jobId) throws IOException {
        PortabilityJob job = this.findJob(jobId);
        JobAuthorization jobAuthorization = job.jobAuthorization().toBuilder().setState(JobAuthorization.State.CREDS_AVAILABLE).build();
        job = job.toBuilder().setAndValidateJobAuthorization(jobAuthorization).build();
        this.updateJob(jobId, job, (previous, updated) -> JobStoreWithValidator.validateForUpdateStateToCredsAvailable(previous));
    }

    private static void validateForUpdateStateToCredsAvailable(PortabilityJob job) {
        DataVertical dataType = job.transferDataType();
        Preconditions.checkArgument((dataType != null ? 1 : 0) != 0, (String)"Missing valid dataTypeParam: %s", (Object)dataType);
        String exportService = job.exportService();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)exportService) ? 1 : 0) != 0, (String)"Missing valid exportService: %s", (Object)exportService);
        String importService = job.importService();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)importService) ? 1 : 0) != 0, (String)"Missing valid importService: %s", (Object)importService);
        Preconditions.checkState((job.jobAuthorization().state() == JobAuthorization.State.INITIAL ? 1 : 0) != 0);
    }

    @Override
    public void updateJobWithCredentials(UUID jobId, PortabilityJob job) throws IOException {
        this.updateJob(jobId, job, (previous, updated) -> {
            Preconditions.checkState((previous.jobAuthorization().state() == JobAuthorization.State.CREDS_ENCRYPTION_KEY_GENERATED ? 1 : 0) != 0);
            Preconditions.checkState((updated.jobAuthorization().state() == JobAuthorization.State.CREDS_STORED ? 1 : 0) != 0);
        });
    }

    @Override
    public void markJobAsFinished(UUID jobId, PortabilityJob.State state) throws IOException {
        Preconditions.checkState((state == PortabilityJob.State.ERROR || state == PortabilityJob.State.COMPLETE ? 1 : 0) != 0);
        this.updateJobState(jobId, state, PortabilityJob.State.IN_PROGRESS, JobAuthorization.State.CREDS_STORED);
    }

    @Override
    public void markJobAsStarted(UUID jobId) throws IOException {
        this.updateJobState(jobId, PortabilityJob.State.IN_PROGRESS, PortabilityJob.State.NEW, JobAuthorization.State.CREDS_STORED);
    }

    @Override
    public void markJobAsTimedOut(UUID jobId) throws IOException {
        PortabilityJob job = this.findJob(jobId);
        this.updateJob(jobId, job.toBuilder().setState(PortabilityJob.State.ERROR).setAndValidateJobAuthorization(job.jobAuthorization().toBuilder().setState(JobAuthorization.State.TIMED_OUT).build()).build());
    }

    protected abstract void updateJob(UUID var1, PortabilityJob var2) throws IOException;

    protected abstract void updateJob(UUID var1, PortabilityJob var2, JobUpdateValidator var3) throws IOException;

    private void updateJobState(UUID jobId, PortabilityJob.State state, PortabilityJob.State prevState, JobAuthorization.State prevAuthState) throws IOException {
        PortabilityJob existingJob = this.findJob(jobId);
        PortabilityJob updatedJob = existingJob.toBuilder().setState(state).build();
        this.updateJob(jobId, updatedJob, (previous, updated) -> {
            Preconditions.checkState((previous.state() == prevState ? 1 : 0) != 0);
            Preconditions.checkState((previous.jobAuthorization().state() == prevAuthState ? 1 : 0) != 0);
        });
    }

    @Override
    public void addFailureReasonToJob(UUID jobId, String failureReason) throws IOException {
        PortabilityJob existingJob = this.findJob(jobId);
        PortabilityJob updatedJob = existingJob.toBuilder().setFailureReason(failureReason).build();
        this.updateJob(jobId, updatedJob);
    }

    public static interface JobUpdateValidator {
        public void validate(PortabilityJob var1, PortabilityJob var2);
    }
}

