/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.spi.cloud.storage;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.datatransferproject.types.common.models.DataModel;

public interface TemporaryPerJobDataStore {
    default public <T extends DataModel> void create(UUID jobId, String key, T model) throws IOException {
        throw new UnsupportedOperationException();
    }

    default public <T extends DataModel> void update(UUID jobId, String key, T model) {
        throw new UnsupportedOperationException();
    }

    default public <T extends DataModel> T findData(UUID jobId, String key, Class<T> type) throws IOException {
        throw new UnsupportedOperationException();
    }

    default public void removeData(UUID JobId, String key) {
        throw new UnsupportedOperationException();
    }

    default public void create(UUID jobId, String key, InputStream stream) throws IOException {
        throw new UnsupportedOperationException();
    }

    default public InputStreamWrapper getStream(UUID jobId, String key) throws IOException {
        throw new UnsupportedOperationException();
    }

    default public File getTempFileFromInputStream(InputStream inputStream, String prefix, String suffix) throws IOException {
        File tmp = Files.createTempFile(prefix, suffix, new FileAttribute[0]).toFile();
        tmp.deleteOnExit();
        Files.copy(inputStream, tmp.toPath(), StandardCopyOption.REPLACE_EXISTING);
        return tmp;
    }

    public static class InputStreamWrapper {
        private final InputStream stream;
        private final Long bytes;

        public InputStreamWrapper(InputStream stream) {
            this.stream = stream;
            this.bytes = 0L;
        }

        public InputStreamWrapper(InputStream stream, Long bytes) {
            this.stream = stream;
            this.bytes = bytes;
        }

        public InputStream getStream() {
            return this.stream;
        }

        public Long getBytes() {
            return this.bytes;
        }
    }
}

