/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.spi.transfer.provider;

import java.util.function.Function;
import org.datatransferproject.spi.transfer.extension.TransferExtension;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.spi.transfer.provider.converter.AnyToAnyExporter;
import org.datatransferproject.spi.transfer.provider.converter.AnyToAnyImporter;
import org.datatransferproject.spi.transfer.provider.converter.MediaExporterDecorator;
import org.datatransferproject.spi.transfer.provider.converter.MediaImporterDecorator;
import org.datatransferproject.types.common.models.ContainerResource;
import org.datatransferproject.types.common.models.DataVertical;
import org.datatransferproject.types.common.models.media.MediaContainerResource;
import org.datatransferproject.types.common.models.photos.PhotosContainerResource;
import org.datatransferproject.types.common.models.videos.VideosContainerResource;

public class TransferCompatibilityProvider {
    public Exporter getCompatibleExporter(TransferExtension extension, DataVertical jobType) {
        Exporter<?, ?> exporter = this.getExporterOrNull(extension, jobType);
        if (exporter != null) {
            return exporter;
        }
        switch (jobType) {
            case MEDIA: {
                exporter = this.getMediaExporter(extension);
                break;
            }
            case PHOTOS: {
                exporter = this.getPhotosExporter(extension);
                break;
            }
            case VIDEOS: {
                exporter = this.getVideosExporter(extension);
            }
        }
        if (exporter == null) {
            return extension.getExporter(jobType);
        }
        return exporter;
    }

    public Importer getCompatibleImporter(TransferExtension extension, DataVertical jobType) {
        Importer<?, ?> importer = this.getImporterOrNull(extension, jobType);
        if (importer != null) {
            return importer;
        }
        switch (jobType) {
            case MEDIA: {
                importer = this.getMediaImporter(extension);
                break;
            }
            case PHOTOS: {
                importer = this.getPhotosImporter(extension);
                break;
            }
            case VIDEOS: {
                importer = this.getVideosImporter(extension);
            }
        }
        if (importer == null) {
            return extension.getImporter(jobType);
        }
        return importer;
    }

    private Importer<?, ?> getVideosImporter(TransferExtension extension) {
        Importer<?, ?> media = this.getImporterOrNull(extension, DataVertical.MEDIA);
        if (media == null) {
            return null;
        }
        return new AnyToAnyImporter(media, MediaContainerResource::videoToMedia);
    }

    private Importer<?, ?> getPhotosImporter(TransferExtension extension) {
        Importer<?, ?> media = this.getImporterOrNull(extension, DataVertical.MEDIA);
        if (media == null) {
            return null;
        }
        return new AnyToAnyImporter(media, MediaContainerResource::photoToMedia);
    }

    private Importer<?, ?> getMediaImporter(TransferExtension extension) {
        Importer<?, ?> photo = this.getImporterOrNull(extension, DataVertical.PHOTOS);
        Importer<?, ?> video = this.getImporterOrNull(extension, DataVertical.VIDEOS);
        if (photo == null || video == null) {
            return null;
        }
        return new MediaImporterDecorator(photo, video);
    }

    private Exporter<?, ?> getVideosExporter(TransferExtension extension) {
        Exporter<?, ?> media = this.getExporterOrNull(extension, DataVertical.MEDIA);
        if (media == null) {
            return null;
        }
        Function<ContainerResource, ContainerResource> converter = cr -> cr instanceof VideosContainerResource ? MediaContainerResource.videoToMedia((VideosContainerResource)((VideosContainerResource)cr)) : cr;
        return new AnyToAnyExporter(media, MediaContainerResource::mediaToVideo, converter);
    }

    private Exporter<?, ?> getPhotosExporter(TransferExtension extension) {
        Exporter<?, ?> media = this.getExporterOrNull(extension, DataVertical.MEDIA);
        if (media == null) {
            return null;
        }
        Function<ContainerResource, ContainerResource> converter = cr -> cr instanceof PhotosContainerResource ? MediaContainerResource.photoToMedia((PhotosContainerResource)((PhotosContainerResource)cr)) : cr;
        return new AnyToAnyExporter(media, MediaContainerResource::mediaToPhoto, converter);
    }

    private Exporter<?, ?> getMediaExporter(TransferExtension extension) {
        Exporter<?, ?> photo = this.getExporterOrNull(extension, DataVertical.PHOTOS);
        Exporter<?, ?> video = this.getExporterOrNull(extension, DataVertical.VIDEOS);
        if (photo == null || video == null) {
            return null;
        }
        return new MediaExporterDecorator(photo, video);
    }

    private Exporter<?, ?> getExporterOrNull(TransferExtension extension, DataVertical jobType) {
        try {
            return extension.getExporter(jobType);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Importer<?, ?> getImporterOrNull(TransferExtension extension, DataVertical jobType) {
        try {
            return extension.getImporter(jobType);
        }
        catch (Exception e) {
            return null;
        }
    }
}

