/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.spi.transfer.provider.converter;

import java.util.UUID;
import java.util.function.Function;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.provider.ImportResult;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.types.common.models.ContainerResource;
import org.datatransferproject.types.transfer.auth.AuthData;

public class AnyToAnyImporter<AD extends AuthData, StandinImporterType extends ContainerResource, ExportingType extends ContainerResource>
implements Importer<AD, ExportingType> {
    private final Importer<AD, StandinImporterType> standinImporter;
    private final Function<ExportingType, StandinImporterType> modelConverter;

    public AnyToAnyImporter(Importer<AD, StandinImporterType> standinImporter, Function<ExportingType, StandinImporterType> modelConverter) {
        this.standinImporter = standinImporter;
        this.modelConverter = modelConverter;
    }

    @Override
    public ImportResult importItem(UUID jobId, IdempotentImportExecutor idempotentExecutor, AD authData, ExportingType data) throws Exception {
        return this.standinImporter.importItem(jobId, idempotentExecutor, authData, (ContainerResource)this.modelConverter.apply(data));
    }
}

