/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.spi.transfer.idempotentexecutor;

import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.types.transfer.errors.ErrorDetail;

public class InMemoryIdempotentImportExecutor
implements IdempotentImportExecutor {
    private final Map<String, Serializable> knownValues = new HashMap<String, Serializable>();
    private final Map<String, ErrorDetail> errors = new HashMap<String, ErrorDetail>();
    private final Map<String, ErrorDetail> recentErrors = new HashMap<String, ErrorDetail>();
    private final Monitor monitor;
    private UUID jobId;

    public InMemoryIdempotentImportExecutor(Monitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public <T extends Serializable> T executeAndSwallowIOExceptions(String idempotentId, String itemName, Callable<T> callable) throws Exception {
        try {
            return this.executeOrThrowException(idempotentId, itemName, callable);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public <T extends Serializable> T executeOrThrowException(String idempotentId, String itemName, Callable<T> callable) throws Exception {
        String jobIdPrefix = "Job " + String.valueOf(this.jobId) + ": ";
        if (this.knownValues.containsKey(idempotentId)) {
            this.monitor.debug(() -> jobIdPrefix + String.format("Using cached key %s from cache for %s", idempotentId, itemName), new Object[0]);
            return (T)this.knownValues.get(idempotentId);
        }
        try {
            Serializable result = (Serializable)callable.call();
            this.knownValues.put(idempotentId, result);
            this.monitor.debug(() -> jobIdPrefix + String.format("Storing key %s in cache for %s", idempotentId, itemName), new Object[0]);
            this.errors.remove(idempotentId);
            return (T)result;
        }
        catch (Exception e) {
            ErrorDetail errorDetail = ErrorDetail.builder().setId(idempotentId).setTitle(itemName).setException(Throwables.getStackTraceAsString((Throwable)e)).build();
            this.errors.put(idempotentId, errorDetail);
            this.recentErrors.put(idempotentId, errorDetail);
            this.monitor.severe(() -> jobIdPrefix + "Problem with importing item: " + String.valueOf(errorDetail), new Object[0]);
            throw e;
        }
    }

    @Override
    public <T extends Serializable> T getCachedValue(String idempotentId) {
        if (!this.knownValues.containsKey(idempotentId)) {
            throw new IllegalArgumentException(idempotentId + " is not a known key, known keys: " + Joiner.on((String)", ").join(this.knownValues.keySet()));
        }
        return (T)this.knownValues.get(idempotentId);
    }

    @Override
    public boolean isKeyCached(String idempotentId) {
        return this.knownValues.containsKey(idempotentId);
    }

    @Override
    public Collection<ErrorDetail> getErrors() {
        return ImmutableList.copyOf(this.errors.values());
    }

    @Override
    public void setJobId(UUID jobId) {
        this.jobId = jobId;
    }

    @Override
    public Collection<ErrorDetail> getRecentErrors() {
        return ImmutableList.copyOf(this.recentErrors.values());
    }

    @Override
    public void resetRecentErrors() {
        this.recentErrors.clear();
    }
}

