/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.spi.transfer.i18n;

import com.google.common.base.Strings;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.datatransferproject.spi.transfer.i18n.MultilingualString;

public class AbstractMultilingualDictionary {
    private Hashtable<MultilingualString, String> dict = new Hashtable();
    private String bundle;

    public AbstractMultilingualDictionary(String locale, String bundle, MultilingualString[] enumValues) {
        this.bundle = bundle;
        if (Strings.isNullOrEmpty((String)locale)) {
            for (MultilingualString value : enumValues) {
                this.dict.put(value, value.getDefaultValue());
            }
            return;
        }
        for (MultilingualString value : enumValues) {
            this.dict.put(value, this.get(value, Locale.forLanguageTag(locale)));
        }
    }

    public String get(MultilingualString multilingualString) {
        return this.dict.get(multilingualString);
    }

    private String get(MultilingualString multilingualString, Locale locale) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(this.bundle, locale);
            return resourceBundle.getString(multilingualString.getKey());
        }
        catch (MissingResourceException e) {
            return multilingualString.getDefaultValue();
        }
    }
}

